/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common.enrichment;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.common.mockito.MockitoEnricher;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;

public final class OpenEJBEnricher {
    private OpenEJBEnricher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enrich(Object testInstance, AppContext ctx) {
        BeanContext context;
        block11: {
            new MockitoEnricher().enrich(testInstance);
            context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getBeanContext((Object)testInstance.getClass().getName());
            BeanManagerImpl bm = OpenEJBEnricher.findBeanManager(ctx);
            if (bm != null && bm.isInUse()) {
                try {
                    Set beans = bm.getBeans(testInstance.getClass(), new Annotation[0]);
                    Bean bean = bm.resolve(beans);
                    CreationalContextImpl cc = bm.createCreationalContext((Contextual)bean);
                    if (context != null) {
                        context.set(CreationalContext.class, (Object)cc);
                    }
                    OWBInjector.inject((BeanManager)bm, (Object)testInstance, (CreationalContext)cc);
                }
                catch (Throwable t) {
                    Logger.getInstance((LogCategory)LogCategory.OPENEJB, OpenEJBEnricher.class).error("Can't inject in " + testInstance.getClass(), t);
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (!(t instanceof Exception)) break block11;
                    throw new OpenEJBRuntimeException((Exception)t);
                }
            }
        }
        if (context != null) {
            ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
            ThreadContext oldContext = ThreadContext.enter((ThreadContext)callContext);
            try {
                InjectionProcessor processor = new InjectionProcessor(testInstance, (Collection)context.getInjections(), context.getJndiContext());
                processor.createInstance();
            }
            catch (OpenEJBException e) {
            }
            finally {
                ThreadContext.exit((ThreadContext)oldContext);
            }
        }
    }

    private static BeanManagerImpl findBeanManager(AppContext ctx) {
        if (ctx != null) {
            return ctx.getWebBeansContext().getBeanManagerImpl();
        }
        try {
            return WebBeansContext.currentInstance().getBeanManagerImpl();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

