/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common.deployment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;

public class DeploymentExceptionObserver {
    private static final Map<Class<?>, Exception> EXCEPTIONS = new HashMap();
    private static final Map<Class<?>, Exception> PARENT_EXCEPTIONS = new HashMap();

    public void observes(@Observes DeploymentException t) throws Exception {
        EXCEPTIONS.put(((Object)((Object)t)).getClass(), (Exception)((Object)t));
        Throwable current = t.getCause();
        while (current != null) {
            if (current instanceof Exception) {
                PARENT_EXCEPTIONS.put(current.getClass(), (Exception)current);
            }
            if (current.getCause() == current) continue;
            current = current.getCause();
        }
        throw t;
    }

    public static Exception getExceptions(Class<?> clazz) {
        Exception ex = EXCEPTIONS.get(clazz);
        if (ex != null) {
            return ex;
        }
        return PARENT_EXCEPTIONS.get(clazz);
    }

    public static Set<Class<?>> availableExceptionTypes() {
        HashSet set = new HashSet(EXCEPTIONS.keySet());
        set.addAll(PARENT_EXCEPTIONS.keySet());
        return set;
    }

    public void cleanUp(@Observes AfterClass event) throws Exception {
        EXCEPTIONS.clear();
        PARENT_EXCEPTIONS.clear();
    }
}

