/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.ext.dynamicreg.server.response;

import org.apache.oltu.oauth2.as.response.OAuthASResponse;
import org.apache.oltu.oauth2.common.message.OAuthResponse;

public class OAuthServerRegistrationResponse
extends OAuthASResponse {
    protected OAuthServerRegistrationResponse(String url, int responseStatus) {
        super(url, responseStatus);
    }

    public static OAuthRegistrationResponseBuilder status(int code) {
        return new OAuthRegistrationResponseBuilder(code);
    }

    public static class OAuthRegistrationResponseBuilder
    extends OAuthResponse.OAuthResponseBuilder {
        public OAuthRegistrationResponseBuilder(int responseCode) {
            super(responseCode);
        }

        public OAuthRegistrationResponseBuilder setClientId(String value) {
            this.parameters.put("client_id", value);
            return this;
        }

        public OAuthRegistrationResponseBuilder setClientSecret(String value) {
            this.parameters.put("client_secret", value);
            return this;
        }

        public OAuthRegistrationResponseBuilder setIssuedAt(String value) {
            this.parameters.put("issued_at", value);
            return this;
        }

        public OAuthRegistrationResponseBuilder setExpiresIn(String value) {
            this.parameters.put("expires_in", Long.parseLong(value));
            return this;
        }

        public OAuthRegistrationResponseBuilder setExpiresIn(Long value) {
            this.parameters.put("expires_in", value);
            return this;
        }

        @Override
        public OAuthRegistrationResponseBuilder setParam(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public OAuthRegistrationResponseBuilder location(String location) {
            this.location = location;
            return this;
        }
    }
}

