/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.ext.dynamicreg.server.request;

import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.oltu.oauth2.common.exception.OAuthRuntimeException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.json.JSONArray;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Logger log = LoggerFactory.getLogger(JSONHttpServletRequestWrapper.class);
    private boolean bodyRead = false;
    final Map<String, String[]> parameters = new HashMap<String, String[]>();

    public JSONHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        if (!this.bodyRead) {
            String body = this.readJsonBody();
            JSONTokener x = new JSONTokener(body);
            if (x.nextClean() != '{') {
                throw new OAuthRuntimeException(String.format("String '%s' is not a valid JSON object representation, a JSON object text must begin with '{'", body));
            }
            block8: while (true) {
                Object value;
                char c = x.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw new OAuthRuntimeException(String.format("String '%s' is not a valid JSON object representation, a JSON object text must end with '}'", body));
                    }
                    case '}': {
                        return Collections.unmodifiableMap(this.parameters);
                    }
                }
                x.back();
                String key = x.nextValue().toString();
                c = x.nextClean();
                if (c == '=') {
                    if (x.next() != '>') {
                        x.back();
                    }
                } else if (c != ':') {
                    throw new OAuthRuntimeException(String.format("String '%s' is not a valid JSON object representation, expected a ':' after the key '%s'", body, key));
                }
                if ((value = x.nextValue()) != null) {
                    if (value instanceof JSONArray) {
                        JSONArray array = (JSONArray)value;
                        String[] values = new String[array.length()];
                        for (int i = 0; i < array.length(); ++i) {
                            values[i] = String.valueOf(array.get(i));
                        }
                        this.parameters.put(key, values);
                    } else {
                        this.parameters.put(key, new String[]{String.valueOf(value)});
                    }
                }
                switch (x.nextClean()) {
                    case ',': 
                    case ';': {
                        if (x.nextClean() == '}') {
                            return Collections.unmodifiableMap(this.parameters);
                        }
                        x.back();
                        continue block8;
                    }
                    case '}': {
                        return Collections.unmodifiableMap(this.parameters);
                    }
                }
                break;
            }
            throw new OAuthRuntimeException(String.format("String '%s' is not a valid JSON object representation, Expected a ',' or '}", body));
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    private String readJsonBody() {
        try {
            ServletRequest request = this.getRequest();
            String contentType = request.getContentType();
            String expectedContentType = "application/json";
            if (!OAuthUtils.hasContentType(contentType, "application/json")) {
                return "";
            }
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream == null) {
                return "";
            }
            this.bodyRead = true;
            return OAuthUtils.saveStreamAsString((InputStream)inputStream);
        }
        catch (Exception e) {
            this.log.error("Dynamic client registration error: ", (Throwable)e);
            throw new OAuthRuntimeException("OAuth server error");
        }
    }
}

