/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.apache.olingo.odata2.jpa.processor.ref.model.Address;
import org.apache.olingo.odata2.jpa.processor.ref.model.Material;

@Entity
@Table(name="T_STORE")
public class Store {
    @Id
    @Column(name="STORE_ID")
    private long storeId;
    @Column(name="STORE_NAME", unique=true)
    private String storeName;
    @Embedded
    private Address storeAddress;
    @ManyToMany(mappedBy="stores")
    private List<Material> materials = new ArrayList<Material>();

    public Store() {
    }

    public Store(String storeName, Address storeAddress) {
        this.storeName = storeName;
        this.storeAddress = storeAddress;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public void setStoreId(long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Address getStoreAddress() {
        return this.storeAddress;
    }

    public void setStoreAddress(Address storeAddress) {
        this.storeAddress = storeAddress;
    }

    public List<Material> getMaterials() {
        return this.materials;
    }

    public void setMaterials(List<Material> materials) {
        this.materials = materials;
        Iterator<Material> itr = materials.iterator();
        while (itr.hasNext()) {
            itr.next().getStores().add(this);
        }
    }
}

