/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.model;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.olingo.odata2.jpa.processor.ref.converter.BlobToByteConverter;
import org.apache.olingo.odata2.jpa.processor.ref.model.Category;
import org.apache.olingo.odata2.jpa.processor.ref.model.Store;

@Entity
@Table(name="T_MATERIAL")
public class Material {
    @Id
    @Column(name="MATERIAL_ID")
    private long materialId;
    @Column(name="MATERIAL_NAME")
    private String materialName;
    @Column(name="PRICE")
    private double price;
    @Column(name="MEASUREMENT_UNIT")
    private String measurementUnit;
    @Lob
    @Column(name="MIMAGE")
    @Convert(converter=BlobToByteConverter.class)
    private Blob materialImage;
    @ManyToMany
    private List<Store> stores = new ArrayList<Store>();
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="TYPE_CODE", referencedColumnName="CODE"), @JoinColumn(name="CAT_ID", referencedColumnName="ID")})
    private Category category;

    public Material() {
    }

    public Material(String materialName, char[] typeCode, double price, String measurementUnit) {
        this.materialName = materialName;
        this.price = price;
        this.measurementUnit = measurementUnit;
    }

    public Blob getMaterialImage() {
        return this.materialImage;
    }

    public void setMaterialImage(Blob materialImage) {
        this.materialImage = materialImage;
    }

    public long getMaterialId() {
        return this.materialId;
    }

    public void setMaterialId(long materialId) {
        this.materialId = materialId;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    public List<Store> getStores() {
        return this.stores;
    }

    public void setStores(List<Store> stores) {
        this.stores = stores;
        Iterator<Store> itr = stores.iterator();
        while (itr.hasNext()) {
            itr.next().getMaterials().add(this);
        }
    }
}

