/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.listeners;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;

public class SalesOrderItemTombstoneListener
extends ODataJPATombstoneEntityListener {
    public Query getQuery(GetEntitySetUriInfo resultsView, EntityManager em) {
        JPQLContextType contextType = null;
        try {
            contextType = !resultsView.getStartEntitySet().getName().equals(resultsView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN : JPQLContextType.SELECT;
            JPQLContext jpqlContext = JPQLContext.createBuilder((JPQLContextType)contextType, (Object)resultsView).build();
            JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
            String deltaToken = ODataJPATombstoneContext.getDeltaToken();
            Query query = null;
            if (deltaToken != null) {
                String statement = jpqlStatement.toString();
                String[] statementParts = statement.split("WHERE");
                String deltaCondition = jpqlContext.getJPAEntityAlias() + ".creationDate >= {ts '" + deltaToken + "'}";
                statement = statementParts.length > 1 ? statementParts[0] + ' ' + "WHERE" + ' ' + deltaCondition + ' ' + "AND" + statementParts[1] : statementParts[0] + ' ' + "WHERE" + ' ' + deltaCondition;
                query = em.createQuery(statement);
            } else {
                query = em.createQuery(jpqlStatement.toString());
            }
            return query;
        }
        catch (EdmException e) {
            return null;
        }
        catch (ODataJPAModelException e) {
            return null;
        }
        catch (ODataJPARuntimeException e) {
            return null;
        }
    }

    public String generateDeltaToken(List<Object> deltas, Query query) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        Date date = new Date(System.currentTimeMillis());
        return dateFormat.format(date);
    }
}

