/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.ref.listeners;

import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAQueryExtensionEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;

public class CustomerQueryExtension
extends ODataJPAQueryExtensionEntityListener {
    public Query getQuery(GetEntitySetUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        FilterExpression filter = uriInfo.getFilter();
        if (filter != null && filter.getExpressionString().startsWith("name")) {
            throw this.createApplicationError("Filter on name not allowed.", Locale.ENGLISH);
        }
        return null;
    }

    public Query getQuery(GetEntitySetCountUriInfo uriInfo, EntityManager em) throws ODataJPARuntimeException {
        Query query = null;
        JPQLContextType contextType = null;
        contextType = uriInfo.getNavigationSegments().size() > 0 ? JPQLContextType.JOIN_SINGLE : JPQLContextType.SELECT_COUNT;
        try {
            JPQLContext jpqlContext = JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriInfo).build();
            query = em.createQuery(JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build().toString());
        }
        catch (ODataJPAModelException oDataJPAModelException) {
        }
        catch (ODataJPARuntimeException oDataJPARuntimeException) {
            // empty catch block
        }
        return query;
    }

    public Query getQuery(GetEntityUriInfo uriInfo, EntityManager em) {
        Query query = null;
        JPQLContextType contextType = null;
        contextType = uriInfo.getNavigationSegments().size() > 0 ? JPQLContextType.JOIN_SINGLE : JPQLContextType.SELECT_SINGLE;
        try {
            JPQLContext jpqlContext = JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriInfo).build();
            query = em.createQuery(JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build().toString());
        }
        catch (ODataJPAModelException oDataJPAModelException) {
        }
        catch (ODataJPARuntimeException oDataJPARuntimeException) {
            // empty catch block
        }
        return query;
    }

    public boolean isTombstoneSupported() {
        return false;
    }
}

