/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.ref.model;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ResourceHelper {
    public static byte[] loadAsByte(String resource) {
        return ResourceHelper.load(resource, new byte[0]);
    }

    public static byte[] load(String resource, byte[] defaultResult) {
        byte[] byArray;
        InputStream instream = null;
        try {
            instream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (instream == null) {
                byte[] byArray2 = defaultResult;
                return byArray2;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int b = 0;
            while ((b = instream.read()) != -1) {
                stream.write(b);
            }
            byArray = stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException ex) {}
            }
        }
        return byArray;
    }

    public static byte[] generateImage() {
        return ResourceHelper.generateImage(Format.PNG);
    }

    public static byte[] generateImage(Format format) {
        try {
            int width = 320;
            int height = 320;
            BufferedImage image = new BufferedImage(width, height, 12);
            WritableRaster raster = image.getRaster();
            int mod = format.ordinal() + 2;
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    if ((h / 32 + w / 32) % mod == 0) {
                        raster.setSample(w, h, 0, 0);
                        continue;
                    }
                    raster.setSample(w, h, 0, 1);
                }
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            ImageIO.write((RenderedImage)image, format.name(), out);
            return out.toByteArray();
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }

    public static enum Format {
        BMP,
        JPEG,
        PNG,
        GIF;

    }
}

