/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.ref.model;

import java.text.DateFormat;
import java.util.Calendar;
import org.apache.olingo.odata2.annotation.processor.ref.model.Location;
import org.apache.olingo.odata2.annotation.processor.ref.model.Manager;
import org.apache.olingo.odata2.annotation.processor.ref.model.ResourceHelper;
import org.apache.olingo.odata2.annotation.processor.ref.model.Room;
import org.apache.olingo.odata2.annotation.processor.ref.model.Team;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.annotation.edm.EdmEntityType;
import org.apache.olingo.odata2.api.annotation.edm.EdmFacets;
import org.apache.olingo.odata2.api.annotation.edm.EdmKey;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceContent;
import org.apache.olingo.odata2.api.annotation.edm.EdmMediaResourceMimeType;
import org.apache.olingo.odata2.api.annotation.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmProperty;
import org.apache.olingo.odata2.api.annotation.edm.EdmType;

@EdmEntityType(name="Employee", namespace="RefScenario")
@EdmEntitySet(name="Employees")
public class Employee {
    @EdmKey
    @EdmProperty(name="EmployeeId", type=EdmType.STRING, facets=@EdmFacets(nullable=false))
    private String employeeId;
    @EdmProperty(name="EmployeeName", facets=@EdmFacets(maxLength=20))
    private String employeeName;
    @EdmProperty
    private Integer age;
    @EdmNavigationProperty(name="ne_Manager", association="ManagerEmployees")
    private Manager manager;
    @EdmNavigationProperty(name="ne_Team", association="TeamEmployees")
    private Team team;
    @EdmNavigationProperty(name="ne_Room")
    private Room room;
    @EdmMediaResourceMimeType
    private String imageType;
    @EdmMediaResourceContent
    private byte[] image;
    @EdmProperty(name="ImageUrl")
    private String imageUrl;
    @EdmProperty(name="EntryDate", type=EdmType.DATE_TIME, facets=@EdmFacets(nullable=true))
    private Calendar entryDate;
    @EdmProperty(name="Location", facets=@EdmFacets(nullable=false))
    private Location location;

    public String getId() {
        return this.employeeId;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getAge() {
        return this.age;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setImageUri(String imageUri) {
        this.imageUrl = imageUri;
    }

    public String getImageUri() {
        return this.imageUrl;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setEntryDate(Calendar date) {
        this.entryDate = date;
    }

    public Calendar getEntryDate() {
        return this.entryDate;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public void setImage(String imageUrl) {
        this.image = Employee.loadImage(imageUrl);
    }

    private static byte[] loadImage(String imageUrl) {
        return ResourceHelper.loadAsByte(imageUrl);
    }

    public byte[] getImage() {
        if (this.image == null) {
            return null;
        }
        return (byte[])this.image.clone();
    }

    public int hashCode() {
        if (this.employeeId == null) {
            return 0;
        }
        return this.employeeId.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.employeeId == ((Employee)obj).employeeId;
    }

    public String toString() {
        return "{\"EmployeeId\":\"" + this.employeeId + "\"," + "\"EmployeeName\":\"" + this.employeeName + "\"," + "\"ManagerId\":" + (this.manager == null ? "null" : "\"" + this.manager.getId() + "\"") + "," + "\"RoomId\":" + (this.room == null ? "null" : "\"" + this.room.getId() + "\"") + "," + "\"TeamId\":" + (this.team == null ? "null" : "\"" + this.team.getId() + "\"") + "," + "\"Location\":" + (this.location == null ? "null" : "{\"City\":" + (this.location.getCity() == null ? "null" : "{\"PostalCode\":\"" + this.location.getCity().getPostalCode() + "\"," + "\"CityName\":\"" + this.location.getCity().getCityName() + "\"}") + "," + "\"Country\":\"" + this.location.getCountry() + "\"}") + "," + "\"Age\":" + this.age + "," + "\"EntryDate\":" + (this.entryDate == null ? "null" : "\"" + DateFormat.getInstance().format(this.entryDate.getTime()) + "\"") + "," + "\"ImageUrl\":\"" + this.imageUrl + "\"}";
    }
}

