/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nlpcraft.examples.sql.db;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.sql.SQLException;
import org.apache.nlpcraft.common.package$;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.tools.Server;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SqlServer$
implements LazyLogging {
    public static SqlServer$ MODULE$;
    private final int H2_PORT;
    private final String H2_BASEDIR;
    private final Seq<String> SRV_PARAMS;
    private final String H2_URL;
    private volatile Server srv;
    private volatile boolean started;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SqlServer$();
    }

    private Logger logger$lzycompute() {
        SqlServer$ sqlServer$ = this;
        synchronized (sqlServer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private final int H2_PORT() {
        return this.H2_PORT;
    }

    private final String H2_BASEDIR() {
        return this.H2_BASEDIR;
    }

    private final Seq<String> SRV_PARAMS() {
        return this.SRV_PARAMS;
    }

    private final String INIT_FILE() {
        return "classpath:northwind.sql";
    }

    public final String H2_URL() {
        return this.H2_URL;
    }

    private Server srv() {
        return this.srv;
    }

    private void srv_$eq(Server x$1) {
        this.srv = x$1;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public void start() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        if (this.started()) {
            throw new IllegalStateException("Server already started.");
        }
        this.srv_$eq(Server.createTcpServer((String[])((String[])this.SRV_PARAMS().toArray(ClassTag$.MODULE$.apply(String.class)))).start());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("H2 server start parameters: {}", new Object[]{this.SRV_PARAMS().mkString(" ")});
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("H2 server status: {}", new Object[]{this.srv().getStatus()});
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        JdbcDataSource ds = new JdbcDataSource();
        ds.setUrl(new StringBuilder(46).append(this.H2_URL()).append(";INIT=RUNSCRIPT FROM '").append("classpath:northwind.sql").append("'").toString());
        try {
            ds.getConnection();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Database schema initialized for: {}", new Object[]{this.H2_URL()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
        }
        catch (SQLException e) {
            BoxedUnit boxedUnit7;
            if (e.getErrorCode() != 42101) {
                throw e;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Database '{}' is NOT initialized because data already exists.", new Object[]{this.H2_URL()});
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("  +-- To re-initialize - delete files in '{}' folder and start again.", new Object[]{this.H2_BASEDIR()});
                boxedUnit4 = BoxedUnit.UNIT;
            }
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("JDBC information:");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("  +-- {}: {}", (Object[])new String[]{package$.MODULE$.c((Object)"URL"), this.H2_URL()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("  +-- {}: org.h2.Driver", new Object[]{package$.MODULE$.c((Object)"Driver")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.started_$eq(true);
    }

    public void stop() {
        BoxedUnit boxedUnit;
        if (!this.started()) {
            throw new IllegalStateException("Server already stopped.");
        }
        if (this.srv() != null) {
            this.srv().stop();
        }
        this.started_$eq(false);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("H2 server stopped.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SqlServer$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.H2_PORT = 9093;
        this.H2_BASEDIR = new File(System.getProperty("user.home"), "nlpcraft-examples/h2").getAbsolutePath();
        this.SRV_PARAMS = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-baseDir", this.H2_BASEDIR(), "-tcpPort", ((Object)BoxesRunTime.boxToInteger((int)this.H2_PORT())).toString(), "-tcpAllowOthers"}));
        this.H2_URL = new StringBuilder(32).append("jdbc:h2:tcp://localhost:").append(this.H2_PORT()).append("/nlp2sql").toString();
        this.started = false;
    }
}

