/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nlpcraft.examples.sql.db;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.nlpcraft.common.ascii.NCAsciiTable$;
import org.apache.nlpcraft.examples.sql.db.SqlQuery;
import org.apache.nlpcraft.examples.sql.db.SqlResult;
import org.apache.nlpcraft.examples.sql.db.SqlServer$;
import org.h2.jdbc.JdbcSQLException;
import org.h2.jdbcx.JdbcDataSource;
import resource.Resource$;
import resource.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SqlAccess$
implements LazyLogging {
    public static SqlAccess$ MODULE$;
    private Connection conn;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SqlAccess$();
    }

    private Logger logger$lzycompute() {
        SqlAccess$ sqlAccess$ = this;
        synchronized (sqlAccess$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private final int LOG_ROWS() {
        return 3;
    }

    private Connection conn() {
        return this.conn;
    }

    private void conn_$eq(Connection x$1) {
        this.conn = x$1;
    }

    public SqlResult select(SqlQuery qry, boolean logResult) {
        SqlResult sqlResult;
        try {
            sqlResult = (SqlResult)package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> this.getPs$1(qry), Resource$.MODULE$.statementResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(PreparedStatement.class)).acquireAndGet((Function1 & Serializable & scala.Serializable)ps -> {
                ((IterableLike)qry.parameters().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SqlAccess$.$anonfun$select$3(ps, x0$1);
                    return BoxedUnit.UNIT;
                });
                return (SqlResult)package$.MODULE$.managed((Function0 & Serializable & scala.Serializable)() -> ps.executeQuery(), Resource$.MODULE$.resultSetResource(), (OptManifest)ClassManifestFactory$.MODULE$.classType(ResultSet.class)).acquireAndGet((Function1 & Serializable & scala.Serializable)rs -> {
                    BoxedUnit boxedUnit;
                    ResultSetMetaData md = rs.getMetaData();
                    int cnt = md.getColumnCount();
                    IndexedSeq cols = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), cnt).map((Function1 & Serializable & scala.Serializable)x$1 -> md.getColumnName(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
                    Seq rows = (Seq)Seq$.MODULE$.empty();
                    while (rs.next()) {
                        rows = (Seq)rows.$colon$plus(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), cnt).map((Function1 & Serializable & scala.Serializable)i -> SqlAccess$.$anonfun$select$7(rs, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    }
                    if (logResult) {
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        if (MODULE$.logger().underlying().isInfoEnabled()) {
                            MODULE$.logger().underlying().info(new StringBuilder(56).append("Query executed successful").append(" [\nsql=\n").append(SqlFormatter.format((String)qry.sql())).append(", \nparameters=").append(qry.parameters().mkString(",")).append(", \nrows=").append(rows.size()).append("]").toString());
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        if (MODULE$.logger().underlying().isInfoEnabled()) {
                            MODULE$.logger().underlying().info("Execution result, first {} lines...", new Object[]{BoxesRunTime.boxToInteger((int)3)});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        Seq data = (Seq)((TraversableLike)rows.take(3)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toSeq(), Seq$.MODULE$.canBuildFrom());
                        if (rows.nonEmpty() && rows.size() > 3) {
                            data = (Seq)data.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IndexedSeq[]{(IndexedSeq)cols.indices().map((Function1 & Serializable & scala.Serializable)x$2 -> SqlAccess$.$anonfun$select$9(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())})), Seq$.MODULE$.canBuildFrom());
                        }
                        if (MODULE$.logger().underlying().isInfoEnabled()) {
                            MODULE$.logger().underlying().info("\n{}", new Object[]{NCAsciiTable$.MODULE$.of((Seq)cols, data)});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return new SqlResult((Seq<String>)cols, (Seq<Seq<String>>)rows);
                });
            });
        }
        catch (SQLException e) {
            BoxedUnit boxedUnit;
            this.close();
            this.conn_$eq(null);
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(48).append("Query executed unsuccessful [sql=").append("\n").append(SqlFormatter.format((String)qry.sql())).append("\nparameters=").append(qry.parameters().mkString(", ")).append("\n]").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw e;
        }
        return sqlResult;
    }

    public void close() {
        block3: {
            if (this.conn() == null) break block3;
            try {
                this.conn().close();
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error closing DB connection.");
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private static final Connection getConnection$1() {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setUrl(SqlServer$.MODULE$.H2_URL());
        return ds.getConnection("", "");
    }

    private final PreparedStatement getPs$1(SqlQuery qry$1) {
        PreparedStatement preparedStatement;
        if (this.conn() == null) {
            this.conn_$eq(SqlAccess$.getConnection$1());
        }
        try {
            preparedStatement = this.conn().prepareStatement(qry$1.sql());
        }
        catch (JdbcSQLException e) {
            this.close();
            if (e.getErrorCode() != 90067) {
                throw e;
            }
            this.conn_$eq(SqlAccess$.getConnection$1());
            preparedStatement = this.conn().prepareStatement(qry$1.sql());
        }
        return preparedStatement;
    }

    public static final /* synthetic */ void $anonfun$select$3(PreparedStatement ps$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object p = tuple2._1();
        int idx = tuple2._2$mcI$sp();
        ps$1.setObject(idx + 1, p);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$select$7(ResultSet rs$1, int i) {
        Object o = rs$1.getObject(i);
        return rs$1.wasNull() ? "" : o.toString();
    }

    public static final /* synthetic */ String $anonfun$select$9(int x$2) {
        return "...";
    }

    private SqlAccess$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

