/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class LogoutFilter
implements Filter {
    private static final String OIDC_LOGOUT_URL = "/nifi-registry-api/access/oidc/logout";
    private static final String LOGOUT_COMPLETE_URL = "/nifi-registry-api/access/logout/complete";
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException {
        boolean supportsOidc = Boolean.parseBoolean(this.servletContext.getInitParameter("oidc-supported"));
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (supportsOidc) {
            httpServletResponse.sendRedirect(OIDC_LOGOUT_URL);
        } else {
            httpServletResponse.sendRedirect(LOGOUT_COMPLETE_URL);
        }
    }

    public void destroy() {
    }
}

