/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class LoginFilter
implements Filter {
    private ServletContext servletContext;

    public void init(FilterConfig filterConfig) {
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException {
        boolean supportsOidc = Boolean.parseBoolean(this.servletContext.getInitParameter("oidc-supported"));
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (supportsOidc) {
            httpResponse.sendRedirect("/nifi-registry-api/access/oidc/request");
        } else {
            httpResponse.sendRedirect("/nifi-registry/#/login");
        }
    }

    public void destroy() {
    }
}

