/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.websocket.WebSocketConfigurationException;
import org.apache.nifi.websocket.WebSocketMessageRouter;
import org.apache.nifi.websocket.WebSocketServerService;
import org.apache.nifi.websocket.jetty.AbstractJettyWebSocketService;
import org.apache.nifi.websocket.jetty.RoutingWebSocketListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

@Tags(value={"WebSocket", "Jetty", "server"})
@CapabilityDescription(value="Implementation of WebSocketServerService. This service uses Jetty WebSocket server module to provide WebSocket session management throughout the application.")
public class JettyWebSocketServer
extends AbstractJettyWebSocketService
implements WebSocketServerService {
    private static final Map<Integer, JettyWebSocketServer> portToControllerService = new ConcurrentHashMap<Integer, JettyWebSocketServer>();
    public static final AllowableValue CLIENT_NONE = new AllowableValue("no", "No Authentication", "Processor will not authenticate clients. Anyone can communicate with this Processor anonymously");
    public static final AllowableValue CLIENT_WANT = new AllowableValue("want", "Want Authentication", "Processor will try to verify the client but if unable to verify will allow the client to communicate anonymously");
    public static final AllowableValue CLIENT_NEED = new AllowableValue("need", "Need Authentication", "Processor will reject communications from any client unless the client provides a certificate that is trusted by the TrustStorespecified in the SSL Context Service");
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("client-authentication").displayName("Client Authentication").description("Specifies whether or not the Processor should authenticate clients. This value is ignored if the <SSL Context Service> Property is not specified or the SSL Context provided uses only a KeyStore and not a TrustStore.").required(true).allowableValues(new AllowableValue[]{CLIENT_NONE, CLIENT_WANT, CLIENT_NEED}).defaultValue(CLIENT_NONE.getValue()).build();
    public static final PropertyDescriptor LISTEN_PORT = new PropertyDescriptor.Builder().name("listen-port").displayName("Listen Port").description("The port number on which this WebSocketServer listens to.").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.PORT_VALIDATOR).build();
    private static final List<PropertyDescriptor> properties;
    private WebSocketPolicy configuredPolicy;
    private Server server;
    private Integer listenPort;
    private ServletHandler servletHandler;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnEnabled
    public void startServer(ConfigurationContext context) throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.getLogger().info("A WebSocket server is already running. {}", new Object[]{this.server});
            return;
        }
        this.configuredPolicy = WebSocketPolicy.newServerPolicy();
        this.configurePolicy(context, this.configuredPolicy);
        this.server = new Server();
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection();
        ServletContextHandler contextHandler = new ServletContextHandler();
        this.servletHandler = new ServletHandler();
        contextHandler.insertHandler((HandlerWrapper)this.servletHandler);
        handlerCollection.setHandlers(new Handler[]{contextHandler});
        this.server.setHandler((Handler)handlerCollection);
        this.listenPort = context.getProperty(LISTEN_PORT).asInteger();
        SslContextFactory sslContextFactory = this.createSslFactory(context);
        ServerConnector serverConnector = this.createConnector(sslContextFactory, this.listenPort);
        this.server.setConnectors(new Connector[]{serverConnector});
        this.servletHandler.addServletWithMapping(JettyWebSocketServlet.class, "/*");
        this.getLogger().info("Starting JettyWebSocketServer on port {}.", new Object[]{this.listenPort});
        this.server.start();
        portToControllerService.put(this.listenPort, this);
    }

    private ServerConnector createConnector(SslContextFactory sslContextFactory, Integer listenPort) {
        ServerConnector serverConnector;
        if (sslContextFactory == null) {
            serverConnector = new ServerConnector(this.server);
        } else {
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            httpsConfiguration.setSecureScheme("https");
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfiguration)});
        }
        serverConnector.setPort(listenPort.intValue());
        return serverConnector;
    }

    private SslContextFactory createSslFactory(ConfigurationContext context) {
        boolean want;
        boolean need;
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        String clientAuthValue = context.getProperty(CLIENT_AUTH).getValue();
        if (CLIENT_NEED.equals((Object)clientAuthValue)) {
            need = true;
            want = false;
        } else if (CLIENT_WANT.equals((Object)clientAuthValue)) {
            need = false;
            want = true;
        } else {
            need = false;
            want = false;
        }
        SslContextFactory sslFactory = sslService == null ? null : this.createSslFactory(sslService, need, want);
        return sslFactory;
    }

    @OnDisabled
    @OnShutdown
    public void stopServer() throws Exception {
        if (this.server == null) {
            return;
        }
        this.getLogger().info("Stopping JettyWebSocketServer.");
        this.server.stop();
        if (portToControllerService.containsKey(this.listenPort) && this.getIdentifier().equals(portToControllerService.get(this.listenPort).getIdentifier())) {
            portToControllerService.remove(this.listenPort);
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.addAll(JettyWebSocketServer.getAbstractPropertyDescriptors());
        props.add(LISTEN_PORT);
        props.add(SSL_CONTEXT);
        props.add(CLIENT_AUTH);
        properties = Collections.unmodifiableList(props);
    }

    public static class JettyWebSocketServlet
    extends WebSocketServlet
    implements WebSocketCreator {
        public void configure(WebSocketServletFactory webSocketServletFactory) {
            webSocketServletFactory.setCreator((WebSocketCreator)this);
        }

        public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
            WebSocketMessageRouter router;
            URI requestURI = servletUpgradeRequest.getRequestURI();
            int port = servletUpgradeRequest.getLocalPort();
            final JettyWebSocketServer service = (JettyWebSocketServer)((Object)portToControllerService.get(port));
            if (service == null) {
                throw new RuntimeException("No controller service is bound with port: " + port);
            }
            String path = requestURI.getPath();
            try {
                router = service.routers.getRouterOrFail(path);
            }
            catch (WebSocketConfigurationException e) {
                throw new IllegalStateException("Failed to get router due to: " + (Object)((Object)e), e);
            }
            RoutingWebSocketListener listener = new RoutingWebSocketListener(router){

                @Override
                public void onWebSocketConnect(Session session) {
                    WebSocketPolicy currentPolicy = session.getPolicy();
                    currentPolicy.setInputBufferSize(service.configuredPolicy.getInputBufferSize());
                    currentPolicy.setMaxTextMessageSize(service.configuredPolicy.getMaxTextMessageSize());
                    currentPolicy.setMaxBinaryMessageSize(service.configuredPolicy.getMaxBinaryMessageSize());
                    super.onWebSocketConnect(session);
                }
            };
            return listener;
        }
    }
}

