/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.nifi.websocket.AbstractWebSocketSession;
import org.eclipse.jetty.websocket.api.Session;

public class JettyWebSocketSession
extends AbstractWebSocketSession {
    private final String sessionId;
    private final Session session;

    public JettyWebSocketSession(String sessionId, Session session) {
        this.sessionId = sessionId;
        this.session = session;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void sendString(String message) throws IOException {
        this.session.getRemote().sendString(message);
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.session.getRemote().sendBytes(data);
    }

    public void close(String reason) throws IOException {
        this.session.close(1000, reason);
    }

    public InetSocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public boolean isSecure() {
        return this.session.isSecure();
    }
}

