/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.websocket.SendMessage;
import org.apache.nifi.websocket.WebSocketConfigurationException;
import org.apache.nifi.websocket.WebSocketMessageRouter;

public class WebSocketMessageRouters {
    private Map<String, WebSocketMessageRouter> routers = new ConcurrentHashMap<String, WebSocketMessageRouter>();

    private synchronized WebSocketMessageRouter getRouterOrCreate(String endpointId) {
        WebSocketMessageRouter router = this.routers.get(endpointId);
        if (router == null) {
            router = new WebSocketMessageRouter(endpointId);
            this.routers.put(endpointId, router);
        }
        return router;
    }

    public WebSocketMessageRouter getRouterOrFail(String endpointId) throws WebSocketConfigurationException {
        WebSocketMessageRouter router = this.routers.get(endpointId);
        if (router == null) {
            throw new WebSocketConfigurationException("No WebSocket router is bound with endpointId: " + endpointId);
        }
        return router;
    }

    public synchronized void registerProcessor(String endpointId, Processor processor) throws WebSocketConfigurationException {
        WebSocketMessageRouter router = this.getRouterOrCreate(endpointId);
        router.registerProcessor(processor);
    }

    public boolean isProcessorRegistered(String endpointId, Processor processor) {
        try {
            WebSocketMessageRouter router = this.getRouterOrFail(endpointId);
            return router.isProcessorRegistered(processor);
        }
        catch (WebSocketConfigurationException e) {
            return false;
        }
    }

    public synchronized void deregisterProcessor(String endpointId, Processor processor) throws WebSocketConfigurationException {
        WebSocketMessageRouter router = this.getRouterOrFail(endpointId);
        router.deregisterProcessor(processor);
    }

    public void sendMessage(String endpointId, String sessionId, SendMessage sendMessage) throws IOException, WebSocketConfigurationException {
        WebSocketMessageRouter router = this.getRouterOrFail(endpointId);
        router.sendMessage(sessionId, sendMessage);
    }

    public void disconnect(String endpointId, String sessionId, String reason) throws IOException, WebSocketConfigurationException {
        WebSocketMessageRouter router = this.getRouterOrFail(endpointId);
        router.disconnect(sessionId, reason);
    }
}

