/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.docs;

import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.nar.ExtensionMapping;

public class DocumentationController
extends HttpServlet {
    private static final int GENERAL_LINK_COUNT = 4;
    private static final int DEVELOPER_LINK_COUNT = 2;
    private ServletContext servletContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExtensionMapping extensionMappings = (ExtensionMapping)this.servletContext.getAttribute("nifi-extension-mapping");
        Collator collator = Collator.getInstance(Locale.US);
        TreeMap<Object, String> processors = new TreeMap<Object, String>(collator);
        for (Object processorClass : extensionMappings.getProcessorNames()) {
            processors.put(StringUtils.substringAfterLast((String)processorClass, (String)"."), (String)processorClass);
        }
        TreeMap<Object, String> controllerServices = new TreeMap<Object, String>(collator);
        for (String controllerServiceClass : extensionMappings.getControllerServiceNames()) {
            controllerServices.put(StringUtils.substringAfterLast((String)controllerServiceClass, (String)"."), controllerServiceClass);
        }
        TreeMap<Object, String> reportingTasks = new TreeMap<Object, String>(collator);
        for (String reportingTaskClass : extensionMappings.getReportingTaskNames()) {
            reportingTasks.put(StringUtils.substringAfterLast((String)reportingTaskClass, (String)"."), reportingTaskClass);
        }
        request.setAttribute("processors", processors);
        request.setAttribute("controllerServices", controllerServices);
        request.setAttribute("reportingTasks", reportingTasks);
        request.setAttribute("totalComponents", (Object)(4 + processors.size() + controllerServices.size() + reportingTasks.size() + 2));
        request.getRequestDispatcher("/WEB-INF/jsp/documentation.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

