/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.update.attributes.api;

import com.sun.jersey.api.NotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.update.attributes.Action;
import org.apache.nifi.update.attributes.Condition;
import org.apache.nifi.update.attributes.Criteria;
import org.apache.nifi.update.attributes.FlowFilePolicy;
import org.apache.nifi.update.attributes.Rule;
import org.apache.nifi.update.attributes.UpdateAttributeModelFactory;
import org.apache.nifi.update.attributes.dto.DtoFactory;
import org.apache.nifi.update.attributes.dto.RuleDTO;
import org.apache.nifi.update.attributes.entity.ActionEntity;
import org.apache.nifi.update.attributes.entity.ConditionEntity;
import org.apache.nifi.update.attributes.entity.EvaluationContextEntity;
import org.apache.nifi.update.attributes.entity.RuleEntity;
import org.apache.nifi.update.attributes.entity.RulesEntity;
import org.apache.nifi.update.attributes.serde.CriteriaSerDe;
import org.apache.nifi.web.ComponentDetails;
import org.apache.nifi.web.InvalidRevisionException;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.NiFiWebConfigurationRequestContext;
import org.apache.nifi.web.NiFiWebRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/criteria")
public class RuleResource {
    private static final Logger logger = LoggerFactory.getLogger(RuleResource.class);
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest request;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/evaluation-context")
    public Response getEvaluationContext(@QueryParam(value="processorId") String processorId) {
        NiFiWebConfigurationContext nifiWebContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        NiFiWebRequestContext contextConfig = this.getRequestContext(processorId);
        Criteria criteria = this.getCriteria(nifiWebContext, contextConfig);
        EvaluationContextEntity responseEntity = new EvaluationContextEntity();
        responseEntity.setProcessorId(processorId);
        responseEntity.setFlowFilePolicy(criteria.getFlowFilePolicy().name());
        responseEntity.setRuleOrder(criteria.getRuleOrder());
        Response.ResponseBuilder response = Response.ok((Object)responseEntity);
        return this.noCache(response).build();
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/evaluation-context")
    public Response updateEvaluationContext(@Context UriInfo uriInfo, EvaluationContextEntity requestEntity) {
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        if (requestEntity == null) {
            throw new WebApplicationException(this.badRequest("The evaluation context must be specified."));
        }
        if (requestEntity.getRuleOrder() == null && requestEntity.getFlowFilePolicy() == null) {
            throw new WebApplicationException(this.badRequest("Either the rule order or the matching strategy must be specified."));
        }
        NiFiWebConfigurationRequestContext requestContext = this.getConfigurationRequestContext(requestEntity.getProcessorId(), requestEntity.getRevision(), requestEntity.getClientId());
        Criteria criteria = this.getCriteria(configurationContext, (NiFiWebRequestContext)requestContext);
        if (requestEntity.getRuleOrder() != null) {
            try {
                criteria.reorder(requestEntity.getRuleOrder());
            }
            catch (IllegalArgumentException iae) {
                throw new WebApplicationException(this.badRequest(iae.getMessage()));
            }
        }
        if (requestEntity.getFlowFilePolicy() != null) {
            try {
                criteria.setFlowFilePolicy(FlowFilePolicy.valueOf((String)requestEntity.getFlowFilePolicy()));
            }
            catch (IllegalArgumentException iae) {
                throw new WebApplicationException(this.badRequest("The specified matching strategy is unknown: " + requestEntity.getFlowFilePolicy()));
            }
        }
        this.saveCriteria(requestContext, criteria);
        EvaluationContextEntity responseEntity = new EvaluationContextEntity();
        responseEntity.setClientId(requestEntity.getClientId());
        responseEntity.setRevision(requestEntity.getRevision());
        responseEntity.setProcessorId(requestEntity.getProcessorId());
        responseEntity.setFlowFilePolicy(criteria.getFlowFilePolicy().name());
        responseEntity.setRuleOrder(criteria.getRuleOrder());
        Response.ResponseBuilder response = Response.ok((Object)responseEntity);
        return this.noCache(response).build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules")
    public Response createRule(@Context UriInfo uriInfo, RuleEntity requestEntity) {
        Rule rule;
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        if (requestEntity == null || requestEntity.getRule() == null) {
            throw new WebApplicationException(this.badRequest("The rule must be specified."));
        }
        RuleDTO ruleDto = requestEntity.getRule();
        if (ruleDto.getId() != null) {
            throw new WebApplicationException(this.badRequest("The rule id cannot be specified."));
        }
        if (ruleDto.getConditions() == null || ruleDto.getConditions().isEmpty()) {
            throw new WebApplicationException(this.badRequest("The rule conditions must be set."));
        }
        if (ruleDto.getActions() == null || ruleDto.getActions().isEmpty()) {
            throw new WebApplicationException(this.badRequest("The rule actions must be set."));
        }
        String uuid = UUID.randomUUID().toString();
        NiFiWebConfigurationRequestContext requestContext = this.getConfigurationRequestContext(requestEntity.getProcessorId(), requestEntity.getRevision(), requestEntity.getClientId());
        Criteria criteria = this.getCriteria(configurationContext, (NiFiWebRequestContext)requestContext);
        UpdateAttributeModelFactory factory = new UpdateAttributeModelFactory();
        try {
            rule = factory.createRule(ruleDto);
            rule.setId(uuid);
        }
        catch (IllegalArgumentException iae) {
            throw new WebApplicationException(this.badRequest(iae.getMessage()));
        }
        criteria.addRule(rule);
        this.saveCriteria(requestContext, criteria);
        RuleEntity responseEntity = new RuleEntity();
        responseEntity.setClientId(requestEntity.getClientId());
        responseEntity.setRevision(requestEntity.getRevision());
        responseEntity.setProcessorId(requestEntity.getProcessorId());
        responseEntity.setRule(DtoFactory.createRuleDTO((Rule)rule));
        UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
        Response.ResponseBuilder response = Response.created((URI)uriBuilder.path(uuid).build(new Object[0])).entity((Object)responseEntity);
        return this.noCache(response).build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules/conditions")
    public Response createCondition(@Context UriInfo uriInfo, @PathParam(value="id") String ruleId, ConditionEntity requestEntity) {
        Condition condition;
        String uuid = UUID.randomUUID().toString();
        try {
            UpdateAttributeModelFactory factory = new UpdateAttributeModelFactory();
            condition = factory.createCondition(requestEntity.getCondition());
            condition.setId(uuid);
        }
        catch (IllegalArgumentException iae) {
            throw new WebApplicationException(this.badRequest(iae.getMessage()));
        }
        ConditionEntity responseEntity = new ConditionEntity();
        responseEntity.setClientId(requestEntity.getClientId());
        responseEntity.setProcessorId(requestEntity.getProcessorId());
        responseEntity.setRevision(requestEntity.getRevision());
        responseEntity.setCondition(DtoFactory.createConditionDTO((Condition)condition));
        UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
        Response.ResponseBuilder response = Response.created((URI)uriBuilder.path(uuid).build(new Object[0])).entity((Object)responseEntity);
        return this.noCache(response).build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules/actions")
    public Response createAction(@Context UriInfo uriInfo, @PathParam(value="id") String ruleId, ActionEntity requestEntity) {
        Action action;
        String uuid = UUID.randomUUID().toString();
        try {
            UpdateAttributeModelFactory factory = new UpdateAttributeModelFactory();
            action = factory.createAction(requestEntity.getAction());
            action.setId(uuid);
        }
        catch (IllegalArgumentException iae) {
            throw new WebApplicationException(this.badRequest(iae.getMessage()));
        }
        ActionEntity responseEntity = new ActionEntity();
        responseEntity.setClientId(requestEntity.getClientId());
        responseEntity.setProcessorId(requestEntity.getProcessorId());
        responseEntity.setRevision(requestEntity.getRevision());
        responseEntity.setAction(DtoFactory.createActionDTO((Action)action));
        UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
        Response.ResponseBuilder response = Response.created((URI)uriBuilder.path(uuid).build(new Object[0])).entity((Object)responseEntity);
        return this.noCache(response).build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules/{id}")
    public Response getRule(@PathParam(value="id") String ruleId, @QueryParam(value="processorId") String processorId, @DefaultValue(value="false") @QueryParam(value="verbose") Boolean verbose) {
        NiFiWebRequestContext requestContext;
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        Criteria criteria = this.getCriteria(configurationContext, requestContext = this.getRequestContext(processorId));
        Rule rule = criteria.getRule(ruleId);
        if (rule == null) {
            throw new NotFoundException();
        }
        RuleDTO ruleDto = DtoFactory.createRuleDTO((Rule)rule);
        if (!verbose.booleanValue()) {
            ruleDto.setConditions(null);
            ruleDto.setActions(null);
        }
        RuleEntity responseEntity = new RuleEntity();
        responseEntity.setProcessorId(processorId);
        responseEntity.setRule(ruleDto);
        Response.ResponseBuilder response = Response.ok((Object)responseEntity);
        return this.noCache(response).build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules")
    public Response getRules(@QueryParam(value="processorId") String processorId, @DefaultValue(value="false") @QueryParam(value="verbose") Boolean verbose) {
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        NiFiWebRequestContext requestContext = this.getRequestContext(processorId);
        Criteria criteria = this.getCriteria(configurationContext, requestContext);
        List rules = criteria.getRules();
        ArrayList<RuleDTO> ruleDtos = null;
        if (rules != null) {
            ruleDtos = new ArrayList<RuleDTO>(rules.size());
            for (Rule rule : rules) {
                RuleDTO ruleDto = DtoFactory.createRuleDTO((Rule)rule);
                ruleDtos.add(ruleDto);
                if (verbose.booleanValue()) continue;
                ruleDto.setConditions(null);
                ruleDto.setActions(null);
            }
        }
        RulesEntity responseEntity = new RulesEntity();
        responseEntity.setProcessorId(processorId);
        responseEntity.setRules(ruleDtos);
        Response.ResponseBuilder response = Response.ok((Object)responseEntity);
        return this.noCache(response).build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules/search-results")
    public Response searchRules(@QueryParam(value="processorId") String processorId, @QueryParam(value="q") String term) {
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-context");
        NiFiWebRequestContext requestContext = this.getRequestContext(processorId);
        Criteria criteria = this.getCriteria(configurationContext, requestContext);
        List rules = criteria.getRules();
        ArrayList<RuleDTO> ruleDtos = null;
        if (rules != null) {
            ruleDtos = new ArrayList<RuleDTO>(rules.size());
            for (Rule rule : rules) {
                if (!StringUtils.containsIgnoreCase((CharSequence)rule.getName(), (CharSequence)term)) continue;
                RuleDTO ruleDto = DtoFactory.createRuleDTO((Rule)rule);
                ruleDtos.add(ruleDto);
            }
        }
        Collections.sort(ruleDtos, new /* Unavailable Anonymous Inner Class!! */);
        RulesEntity responseEntity = new RulesEntity();
        responseEntity.setProcessorId(processorId);
        responseEntity.setRules(ruleDtos);
        Response.ResponseBuilder response = Response.ok((Object)responseEntity);
        return this.noCache(response).build();
    }

    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules/{id}")
    public Response updateRule(@Context UriInfo uriInfo, @PathParam(value="id") String ruleId, RuleEntity requestEntity) {
        Response.ResponseBuilder response;
        NiFiWebConfigurationContext nifiWebContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        if (requestEntity == null || requestEntity.getRule() == null) {
            throw new WebApplicationException(this.badRequest("The rule must be specified."));
        }
        RuleDTO ruleDto = requestEntity.getRule();
        if (ruleDto.getId() == null) {
            throw new WebApplicationException(this.badRequest("The rule id must be specified."));
        }
        if (!ruleDto.getId().equals(ruleId)) {
            throw new WebApplicationException(this.badRequest("The rule id in the path does not equal the rule id in the request body."));
        }
        if (ruleDto.getName() == null || ruleDto.getName().isEmpty()) {
            throw new WebApplicationException(this.badRequest("The rule name must be specified and cannot be blank."));
        }
        if (ruleDto.getConditions() == null || ruleDto.getConditions().isEmpty()) {
            throw new WebApplicationException(this.badRequest("The rule conditions must be set."));
        }
        if (ruleDto.getActions() == null || ruleDto.getActions().isEmpty()) {
            throw new WebApplicationException(this.badRequest("The rule actions must be set."));
        }
        NiFiWebConfigurationRequestContext requestContext = this.getConfigurationRequestContext(requestEntity.getProcessorId(), requestEntity.getRevision(), requestEntity.getClientId());
        UpdateAttributeModelFactory factory = new UpdateAttributeModelFactory();
        Criteria criteria = this.getCriteria(nifiWebContext, (NiFiWebRequestContext)requestContext);
        Rule rule = criteria.getRule(ruleId);
        boolean newRule = false;
        if (rule == null) {
            newRule = true;
            rule = new Rule();
            rule.setId(ruleId);
        }
        try {
            Set conditions = factory.createConditions(ruleDto.getConditions());
            Set actions = factory.createActions(ruleDto.getActions());
            rule.setName(ruleDto.getName());
            rule.setConditions(conditions);
            rule.setActions(actions);
        }
        catch (IllegalArgumentException iae) {
            throw new WebApplicationException(this.badRequest(iae.getMessage()));
        }
        if (newRule) {
            criteria.addRule(rule);
        }
        this.saveCriteria(requestContext, criteria);
        RuleEntity responseEntity = new RuleEntity();
        responseEntity.setClientId(requestEntity.getClientId());
        responseEntity.setRevision(requestEntity.getRevision());
        responseEntity.setProcessorId(requestEntity.getProcessorId());
        responseEntity.setRule(DtoFactory.createRuleDTO((Rule)rule));
        if (newRule) {
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder();
            response = Response.created((URI)uriBuilder.path(ruleId).build(new Object[0])).entity((Object)responseEntity);
        } else {
            response = Response.ok((Object)responseEntity);
        }
        return this.noCache(response).build();
    }

    @DELETE
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/rules/{id}")
    public Response deleteRule(@PathParam(value="id") String ruleId, @QueryParam(value="processorId") String processorId, @QueryParam(value="clientId") String clientId, @QueryParam(value="revision") Long revision) {
        NiFiWebConfigurationRequestContext requestContext;
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        Criteria criteria = this.getCriteria(configurationContext, (NiFiWebRequestContext)(requestContext = this.getConfigurationRequestContext(processorId, revision, clientId)));
        Rule rule = criteria.getRule(ruleId);
        if (rule == null) {
            throw new NotFoundException();
        }
        criteria.deleteRule(rule);
        this.saveCriteria(requestContext, criteria);
        RulesEntity responseEntity = new RulesEntity();
        responseEntity.setClientId(clientId);
        responseEntity.setRevision(revision);
        responseEntity.setProcessorId(processorId);
        Response.ResponseBuilder response = Response.ok((Object)responseEntity);
        return this.noCache(response).build();
    }

    private Criteria getCriteria(NiFiWebConfigurationContext configurationContext, NiFiWebRequestContext requestContext) {
        ComponentDetails processorDetails;
        try {
            processorDetails = configurationContext.getComponentDetails(requestContext);
        }
        catch (InvalidRevisionException ire) {
            throw new WebApplicationException(this.invalidRevision(ire.getMessage()));
        }
        catch (Exception e) {
            String message = String.format("Unable to get UpdateAttribute[id=%s] criteria: %s", requestContext.getId(), e);
            logger.error(message, (Throwable)e);
            throw new WebApplicationException(this.error(message));
        }
        Criteria criteria = null;
        if (processorDetails != null) {
            try {
                criteria = CriteriaSerDe.deserialize((String)processorDetails.getAnnotationData());
            }
            catch (IllegalArgumentException iae) {
                String message = String.format("Unable to deserialize existing rules for UpdateAttribute[id=%s]. Deserialization error: %s", requestContext.getId(), iae);
                logger.error(message, (Throwable)iae);
                throw new WebApplicationException(this.error(message));
            }
        }
        if (criteria == null) {
            criteria = new Criteria();
        }
        return criteria;
    }

    private void saveCriteria(NiFiWebConfigurationRequestContext requestContext, Criteria criteria) {
        String annotationData = CriteriaSerDe.serialize((Criteria)criteria);
        NiFiWebConfigurationContext configurationContext = (NiFiWebConfigurationContext)this.servletContext.getAttribute("nifi-web-configuration-context");
        try {
            configurationContext.setAnnotationData(requestContext, annotationData);
        }
        catch (InvalidRevisionException ire) {
            throw new WebApplicationException(this.invalidRevision(ire.getMessage()));
        }
        catch (Exception e) {
            String message = String.format("Unable to save UpdateAttribute[id=%s] criteria: %s", requestContext.getId(), e);
            logger.error(message, (Throwable)e);
            throw new WebApplicationException(this.error(message));
        }
    }

    private NiFiWebRequestContext getRequestContext(String processorId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private NiFiWebConfigurationRequestContext getConfigurationRequestContext(String processorId, Long revision, String clientId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Response badRequest(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).type("text/plain").build();
    }

    private Response invalidRevision(String message) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)message).type("text/plain").build();
    }

    private Response error(String message) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).type("text/plain").build();
    }

    private Response.ResponseBuilder noCache(Response.ResponseBuilder response) {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setPrivate(true);
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return response.cacheControl(cacheControl);
    }
}

