/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.update.attributes;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.update.attributes.Action;
import org.apache.nifi.update.attributes.Condition;
import org.apache.nifi.update.attributes.Rule;
import org.apache.nifi.update.attributes.dto.ActionDTO;
import org.apache.nifi.update.attributes.dto.ConditionDTO;
import org.apache.nifi.update.attributes.dto.RuleDTO;

public class UpdateAttributeModelFactory {
    public Rule createRule(RuleDTO dto) {
        if (dto == null) {
            throw new IllegalArgumentException("Rule must be specified.");
        }
        if (dto.getName() == null) {
            throw new IllegalArgumentException("Rule name must be specified.");
        }
        if (dto.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Rule name cannot be blank.");
        }
        Rule rule = new Rule();
        rule.setId(dto.getId());
        rule.setName(dto.getName());
        rule.setConditions(this.createConditions(dto.getConditions()));
        rule.setActions(this.createActions(dto.getActions()));
        return rule;
    }

    public Set<Condition> createConditions(Set<ConditionDTO> conditionDtos) {
        if (conditionDtos == null) {
            throw new IllegalArgumentException("Conditions must be specified.");
        }
        HashSet<Condition> conditions = new HashSet<Condition>(conditionDtos.size());
        for (ConditionDTO condition : conditionDtos) {
            conditions.add(this.createCondition(condition));
        }
        return conditions;
    }

    public Condition createCondition(ConditionDTO dto) {
        if (dto == null) {
            throw new IllegalArgumentException("Condition must be specified.");
        }
        if (dto.getExpression() == null) {
            throw new IllegalArgumentException("Conditions: Expression must be specified.");
        }
        StandardExpressionLanguageCompiler elCompiler = new StandardExpressionLanguageCompiler();
        String syntaxError = elCompiler.validateExpression(dto.getExpression(), false);
        if (syntaxError != null) {
            throw new IllegalArgumentException(syntaxError);
        }
        AttributeExpression.ResultType resultType = elCompiler.getResultType(dto.getExpression());
        if (!AttributeExpression.ResultType.BOOLEAN.equals((Object)resultType)) {
            throw new IllegalArgumentException("Return type of condition is " + resultType + " but expected type BOOLEAN");
        }
        Condition condition = new Condition();
        condition.setId(dto.getId());
        condition.setExpression(dto.getExpression());
        return condition;
    }

    public Set<Action> createActions(Set<ActionDTO> actionDtos) {
        if (actionDtos == null) {
            throw new IllegalArgumentException("Actions must be specified.");
        }
        HashSet<Action> actions = new HashSet<Action>(actionDtos.size());
        for (ActionDTO action : actionDtos) {
            actions.add(this.createAction(action));
        }
        return actions;
    }

    public Action createAction(ActionDTO dto) {
        if (dto == null) {
            throw new IllegalArgumentException("Action must be specified.");
        }
        if (dto.getAttribute() == null) {
            throw new IllegalArgumentException("Actions: Attribute name must be specified.");
        }
        if (dto.getValue() == null) {
            throw new IllegalArgumentException(String.format("Actions: Value for attribute '%s' must be specified.", dto.getAttribute()));
        }
        try {
            Query.validateExpression((String)dto.getValue(), (boolean)true);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw new IllegalArgumentException("Invalid Expression: " + e.toString(), e);
        }
        Action action = new Action();
        action.setId(dto.getId());
        action.setAttribute(dto.getAttribute());
        action.setValue(dto.getValue());
        return action;
    }
}

