/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.attributes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;
import org.apache.nifi.search.Searchable;
import org.apache.nifi.update.attributes.Action;
import org.apache.nifi.update.attributes.Condition;
import org.apache.nifi.update.attributes.Criteria;
import org.apache.nifi.update.attributes.FlowFilePolicy;
import org.apache.nifi.update.attributes.Rule;
import org.apache.nifi.update.attributes.serde.CriteriaSerDe;

@EventDriven
@SideEffectFree
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"attributes", "modification", "update", "delete", "Attribute Expression Language"})
@CapabilityDescription(value="Updates the Attributes for a FlowFile by using the Attribute Expression Language and/or deletes the attributes based on a regular expression")
@DynamicProperty(name="A FlowFile attribute to update", value="The value to set it to", supportsExpressionLanguage=true, description="Updates a FlowFile attribute specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@WritesAttribute(attribute="See additional details", description="This processor may write or remove zero or more attributes as described in additional details")
public class UpdateAttribute
extends AbstractProcessor
implements Searchable {
    private final AtomicReference<Criteria> criteriaCache = new AtomicReference<Object>(null);
    private final ConcurrentMap<String, PropertyValue> propertyValues = new ConcurrentHashMap<String, PropertyValue>();
    private final Set<Relationship> relationships;
    private static final Validator DELETE_PROPERTY_VALIDATOR = new Validator(){
        private final Validator DPV_RE_VALIDATOR = StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true);

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                AttributeExpression.ResultType resultType = context.newExpressionLanguageCompiler().getResultType(input);
                if (!resultType.equals((Object)AttributeExpression.ResultType.STRING)) {
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Expected property to to return type " + AttributeExpression.ResultType.STRING + " but expression returns type " + resultType).build();
                }
                return new ValidationResult.Builder().subject(subject).input(input).valid(true).explanation("Property returns type " + AttributeExpression.ResultType.STRING).build();
            }
            return this.DPV_RE_VALIDATOR.validate(subject, input, context);
        }
    };
    public static final PropertyDescriptor DELETE_ATTRIBUTES = new PropertyDescriptor.Builder().name("Delete Attributes Expression").description("Regular expression for attributes to be deleted from flowfiles.").required(false).addValidator(DELETE_PROPERTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().description("All FlowFiles are routed to this relationship").name("success").build();

    public UpdateAttribute() {
        HashSet<Relationship> relationshipSet = new HashSet<Relationship>();
        relationshipSet.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(relationshipSet);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(DELETE_ATTRIBUTES);
        return Collections.unmodifiableList(descriptors);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(true).dynamic(true).build();
    }

    @OnScheduled
    public void clearPropertyValueMap() {
        this.propertyValues.clear();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> reasons = new ArrayList<ValidationResult>(super.customValidate(context));
        Criteria criteria = null;
        try {
            criteria = CriteriaSerDe.deserialize((String)context.getAnnotationData());
        }
        catch (IllegalArgumentException iae) {
            reasons.add(new ValidationResult.Builder().valid(false).explanation("Unable to deserialize the update criteria." + iae.getMessage()).build());
        }
        if (criteria != null) {
            List rules = criteria.getRules();
            if (rules == null) {
                reasons.add(new ValidationResult.Builder().valid(false).explanation("Update criteria has been specified by no rules were found.").build());
            } else {
                for (Rule rule : rules) {
                    Set conditions;
                    if (rule.getName() == null || rule.getName().trim().isEmpty()) {
                        reasons.add(new ValidationResult.Builder().valid(false).explanation("A rule name was not specified.").build());
                    }
                    if ((conditions = rule.getConditions()) == null) {
                        reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No conditions for rule '%s' found.", rule.getName())).build());
                    } else {
                        for (Condition condition : conditions) {
                            if (condition.getExpression() == null) {
                                reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No expression for a condition in rule '%s' was found.", rule.getName())).build());
                                continue;
                            }
                            String expression = condition.getExpression().trim();
                            reasons.add(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.BOOLEAN, (boolean)false).validate(String.format("Condition for rule '%s'.", rule.getName()), expression, context));
                        }
                    }
                    Set actions = rule.getActions();
                    if (actions == null) {
                        reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No actions for rule '%s' found.", rule.getName())).build());
                        continue;
                    }
                    for (Action action : actions) {
                        if (action.getAttribute() == null) {
                            reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("An action in rule '%s' is missing the attribute name.", rule.getName())).build());
                            continue;
                        }
                        if (action.getValue() == null) {
                            reasons.add(new ValidationResult.Builder().valid(false).explanation(String.format("No value for attribute '%s' in rule '%s' was found.", action.getAttribute(), rule.getName())).build());
                            continue;
                        }
                        reasons.add(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true).validate(String.format("Action for rule '%s'.", rule.getName()), action.getValue(), context));
                    }
                }
            }
        }
        return reasons;
    }

    public Collection<SearchResult> search(SearchContext context) {
        String term = context.getSearchTerm();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (StringUtils.isBlank((CharSequence)context.getAnnotationData())) {
            return results;
        }
        try {
            Criteria criteria = CriteriaSerDe.deserialize((String)context.getAnnotationData());
            if (criteria.getRules() != null) {
                FlowFilePolicy flowFilePolicy = criteria.getFlowFilePolicy();
                if (flowFilePolicy != null && StringUtils.containsIgnoreCase((CharSequence)flowFilePolicy.name(), (CharSequence)term)) {
                    results.add(new SearchResult.Builder().label("FlowFile policy").match(flowFilePolicy.name()).build());
                }
                for (Rule rule : criteria.getRules()) {
                    if (StringUtils.containsIgnoreCase((CharSequence)rule.getName(), (CharSequence)term)) {
                        results.add(new SearchResult.Builder().label("Rule name").match(rule.getName()).build());
                    }
                    if (rule.getConditions() != null) {
                        for (Condition condition : rule.getConditions()) {
                            if (!StringUtils.containsIgnoreCase((CharSequence)condition.getExpression(), (CharSequence)term)) continue;
                            results.add(new SearchResult.Builder().label(String.format("Condition in rule '%s'", rule.getName())).match(condition.getExpression()).build());
                        }
                    }
                    if (rule.getActions() == null) continue;
                    for (Action action : rule.getActions()) {
                        if (StringUtils.containsIgnoreCase((CharSequence)action.getAttribute(), (CharSequence)term)) {
                            results.add(new SearchResult.Builder().label(String.format("Action in rule '%s'", rule.getName())).match(action.getAttribute()).build());
                        }
                        if (!StringUtils.containsIgnoreCase((CharSequence)action.getValue(), (CharSequence)term)) continue;
                        results.add(new SearchResult.Builder().label(String.format("Action in rule '%s'", rule.getName())).match(action.getValue()).build());
                    }
                }
            }
            return results;
        }
        catch (Exception e) {
            return results;
        }
    }

    @OnScheduled
    public void parseAnnotationData(ProcessContext context) {
        this.criteriaCache.set(CriteriaSerDe.deserialize((String)context.getAnnotationData()));
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        ProcessorLog logger = this.getLogger();
        Criteria criteria = this.criteriaCache.get();
        List flowFiles = session.get(100);
        if (flowFiles.isEmpty()) {
            return;
        }
        Map properties = context.getProperties();
        Map<String, Action> defaultActions = this.getDefaultActions(properties);
        HashMap<FlowFile, List<Rule>> matchedRules = new HashMap<FlowFile, List<Rule>>();
        for (FlowFile flowFile : flowFiles) {
            matchedRules.clear();
            if (criteria != null && this.evaluateCriteria(session, context, criteria, flowFile, matchedRules)) {
                for (Map.Entry entry : matchedRules.entrySet()) {
                    FlowFile match = (FlowFile)entry.getKey();
                    List rules = (List)entry.getValue();
                    match = this.executeActions(session, context, rules, defaultActions, match);
                    logger.info("Updated attributes for {}; transferring to '{}'", new Object[]{match, REL_SUCCESS.getName()});
                    session.getProvenanceReporter().modifyAttributes(match);
                    session.transfer(match, REL_SUCCESS);
                }
                continue;
            }
            flowFile = this.executeActions(session, context, null, defaultActions, flowFile);
            logger.info("Updated attributes for {}; transferring to '{}'", new Object[]{flowFile, REL_SUCCESS.getName()});
            session.getProvenanceReporter().modifyAttributes(flowFile);
            session.transfer(flowFile, REL_SUCCESS);
        }
    }

    private boolean evaluateCriteria(ProcessSession session, ProcessContext context, Criteria criteria, FlowFile flowfile, Map<FlowFile, List<Rule>> matchedRules) {
        ProcessorLog logger = this.getLogger();
        List rules = criteria.getRules();
        for (Rule rule : rules) {
            if (!this.evaluateRule(context, rule, flowfile)) continue;
            FlowFile flowfileToUse = FlowFilePolicy.USE_ORIGINAL.equals((Object)criteria.getFlowFilePolicy()) || matchedRules.isEmpty() ? flowfile : session.clone(flowfile);
            List<Rule> rulesForFlowFile = matchedRules.get(flowfileToUse);
            if (rulesForFlowFile == null) {
                rulesForFlowFile = new ArrayList<Rule>();
                matchedRules.put(flowfileToUse, rulesForFlowFile);
            }
            rulesForFlowFile.add(rule);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)((Object)this) + " all conditions met for rule '" + rule.getName() + "'. Using flow file - " + flowfileToUse);
        }
        return !matchedRules.isEmpty();
    }

    private boolean evaluateRule(ProcessContext context, Rule rule, FlowFile flowfile) {
        for (Condition condition : rule.getConditions()) {
            if (this.evaluateCondition(context, condition, flowfile)) continue;
            return false;
        }
        return true;
    }

    private PropertyValue getPropertyValue(String text, ProcessContext context) {
        PropertyValue previousValue;
        PropertyValue currentValue = (PropertyValue)this.propertyValues.get(text);
        if (currentValue == null && (previousValue = this.propertyValues.putIfAbsent(text, currentValue = context.newPropertyValue(text))) != null) {
            currentValue = previousValue;
        }
        return currentValue;
    }

    private boolean evaluateCondition(ProcessContext context, Condition condition, FlowFile flowfile) {
        try {
            return this.getPropertyValue(condition.getExpression(), context).evaluateAttributeExpressions(flowfile).asBoolean();
        }
        catch (ProcessException pe) {
            throw new ProcessException(String.format("Unable to evaluate condition '%s': %s.", new Object[]{condition.getExpression(), pe}), (Throwable)pe);
        }
    }

    private FlowFile executeActions(ProcessSession session, ProcessContext context, List<Rule> rules, Map<String, Action> defaultActions, FlowFile flowfile) {
        String ruleName;
        ProcessorLog logger = this.getLogger();
        HashMap<String, Action> actions = new HashMap<String, Action>(defaultActions);
        String string = ruleName = rules == null || rules.isEmpty() ? "default" : rules.get(rules.size() - 1).getName();
        if (rules != null && rules.size() > 0) {
            for (Rule rule : rules) {
                for (Action action : rule.getActions()) {
                    actions.put(action.getAttribute(), action);
                }
            }
            Action matchedRuleAction = new Action();
            matchedRuleAction.setAttribute(((Object)((Object)this)).getClass().getSimpleName() + ".matchedRule");
            matchedRuleAction.setValue(ruleName);
            actions.put(matchedRuleAction.getAttribute(), matchedRuleAction);
        }
        HashMap<String, String> attributesToUpdate = new HashMap<String, String>(actions.size());
        HashSet<String> attributesToDelete = new HashSet<String>(actions.size());
        for (Action action : actions.values()) {
            if (!action.getAttribute().equals(DELETE_ATTRIBUTES.getName())) {
                try {
                    String newAttributeValue = this.getPropertyValue(action.getValue(), context).evaluateAttributeExpressions(flowfile).getValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("%s setting attribute '%s' = '%s' for %s per rule '%s'.", new Object[]{this, action.getAttribute(), newAttributeValue, flowfile, ruleName}));
                    }
                    attributesToUpdate.put(action.getAttribute(), newAttributeValue);
                    continue;
                }
                catch (ProcessException pe) {
                    throw new ProcessException(String.format("Unable to evaluate new value for attribute '%s': %s.", new Object[]{action.getAttribute(), pe}), (Throwable)pe);
                }
            }
            try {
                String actionValue = action.getValue();
                String regex = actionValue == null ? null : this.getPropertyValue(actionValue, context).evaluateAttributeExpressions(flowfile).getValue();
                if (regex == null) continue;
                Pattern pattern = Pattern.compile(regex);
                Set attributeKeys = flowfile.getAttributes().keySet();
                for (String key : attributeKeys) {
                    if (!pattern.matcher(key).matches()) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("%s deleting attribute '%s' for %s per regex '%s'.", new Object[]{this, key, flowfile, regex}));
                    }
                    attributesToDelete.add(key);
                }
            }
            catch (ProcessException pe) {
                throw new ProcessException(String.format("Unable to delete attribute '%s': %s.", new Object[]{action.getAttribute(), pe}), (Throwable)pe);
            }
        }
        String alternateIdentifierAdd = (String)attributesToUpdate.get(CoreAttributes.ALTERNATE_IDENTIFIER.key());
        if (alternateIdentifierAdd != null) {
            try {
                URI uri = new URI(alternateIdentifierAdd);
                String namespace = uri.getScheme();
                if (namespace != null) {
                    String identifier = alternateIdentifierAdd.substring(Math.min(namespace.length() + 1, alternateIdentifierAdd.length() - 1));
                    session.getProvenanceReporter().associate(flowfile, namespace, identifier);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return session.removeAllAttributes(session.putAllAttributes(flowfile, attributesToUpdate), attributesToDelete);
    }

    private Map<String, Action> getDefaultActions(Map<PropertyDescriptor, String> properties) {
        HashMap<String, Action> defaultActions = new HashMap<String, Action>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            Action action = new Action();
            action.setAttribute(entry.getKey().getName());
            action.setValue(entry.getValue());
            defaultActions.put(action.getAttribute(), action);
        }
        return defaultActions;
    }
}

