/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cs.tests.system;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.cs.tests.system.CountService;
import org.apache.nifi.processor.util.StandardValidators;

public class StandardCountService
extends AbstractControllerService
implements CountService {
    static final PropertyDescriptor COUNT_SERVICE = new PropertyDescriptor.Builder().name("Dependent Service").displayName("Dependent Service").description("An additional Controller Service to trigger for counting").required(false).identifiesControllerService(CountService.class).build();
    static final PropertyDescriptor START_VALUE = new PropertyDescriptor.Builder().name("Start Value").displayName("Start Value").description("The value to start counting from").required(true).addValidator(StandardValidators.LONG_VALIDATOR).defaultValue("0").build();
    private final AtomicLong counter = new AtomicLong(0L);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return List.of(COUNT_SERVICE, START_VALUE);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        long startValue = Long.parseLong(context.getProperty(START_VALUE).getValue());
        this.getLogger().info("Setting counter to {}", new Object[]{startValue});
        this.counter.set(startValue);
    }

    public long count() {
        CountService additionalService = (CountService)this.getConfigurationContext().getProperty(COUNT_SERVICE).asControllerService(CountService.class);
        long additionalCount = additionalService == null ? 0L : additionalService.count();
        return additionalCount + this.counter.incrementAndGet();
    }
}

