/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog.parsers;

import com.github.palindromicity.syslog.KeyProvider;
import com.github.palindromicity.syslog.NilPolicy;
import com.github.palindromicity.syslog.StructuredDataPolicy;
import com.github.palindromicity.syslog.SyslogParser;
import com.github.palindromicity.syslog.SyslogParserBuilder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.syslog.events.Syslog5424Event;
import org.apache.nifi.syslog.keyproviders.SyslogPrefixedKeyProvider;
import org.apache.nifi.syslog.utils.NifiStructuredDataPolicy;
import org.apache.nifi.syslog.utils.NilHandlingPolicy;

public class StrictSyslog5424Parser {
    private Charset charset;
    private SyslogParser parser;

    public StrictSyslog5424Parser() {
        this(StandardCharsets.UTF_8, NilHandlingPolicy.NULL, NifiStructuredDataPolicy.FLATTEN, new SyslogPrefixedKeyProvider());
    }

    public StrictSyslog5424Parser(Charset charset, NilHandlingPolicy nilPolicy, NifiStructuredDataPolicy structuredDataPolicy, KeyProvider keyProvider) {
        this.charset = charset;
        this.parser = new SyslogParserBuilder().withNilPolicy(NilPolicy.valueOf((String)nilPolicy.name())).withStructuredDataPolicy(StructuredDataPolicy.valueOf((String)structuredDataPolicy.name())).withKeyProvider(keyProvider).build();
    }

    public Syslog5424Event parseEvent(ByteBuffer buffer) {
        return this.parseEvent(buffer, null);
    }

    public Syslog5424Event parseEvent(ByteBuffer buffer, String sender) {
        if (buffer == null) {
            return null;
        }
        return this.parseEvent(this.bufferToBytes(buffer), sender);
    }

    public Syslog5424Event parseEvent(byte[] bytes, String sender) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        int length = bytes.length;
        if (bytes[length - 1] == 10) {
            --length;
        }
        String message = new String(bytes, 0, length, this.charset);
        Syslog5424Event.Builder builder = new Syslog5424Event.Builder().valid(false).fullMessage(message).rawMessage(bytes).sender(sender);
        try {
            this.parser.parseLine(message, builder::fieldMap);
            builder.valid(true);
        }
        catch (Exception e) {
            builder.valid(false);
            builder.exception(e);
        }
        return builder.build();
    }

    public String getCharsetName() {
        return this.charset == null ? StandardCharsets.UTF_8.name() : this.charset.name();
    }

    private byte[] bufferToBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.position() != 0) {
            buffer.flip();
        }
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes, 0, buffer.limit());
        return bytes;
    }
}

