/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"disk", "storage", "warning", "monitoring", "repo"})
@CapabilityDescription(value="Checks the amount of storage space available for the Content Repository and FlowFile Repository and warns (via a log message and a System-Level Bulletin) if the partition on which either repository exceeds some configurable threshold of storage space")
public class MonitorDiskUsage
extends AbstractReportingTask {
    private static final Logger logger = LoggerFactory.getLogger(MonitorDiskUsage.class);
    private static final Pattern PERCENT_PATTERN = Pattern.compile("(\\d+{1,2})%");
    public static final PropertyDescriptor CONTENT_REPO_THRESHOLD = new PropertyDescriptor.Builder().name("Content Repository Threshold").description("The threshold at which a bulletin will be generated to indicate that the disk usage of the Content Repository is of concern").required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)PERCENT_PATTERN)).defaultValue("80%").build();
    public static final PropertyDescriptor FLOWFILE_REPO_THRESHOLD = new PropertyDescriptor.Builder().name("FlowFile Repository Threshold").description("The threshold at which a bulletin will be generated to indicate that the disk usage of the FlowFile Repository is of concern").required(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)PERCENT_PATTERN)).defaultValue("80%").build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(2);
        descriptors.add(CONTENT_REPO_THRESHOLD);
        descriptors.add(FLOWFILE_REPO_THRESHOLD);
        return descriptors;
    }

    public void onTrigger(ReportingContext context) {
        String contentRepoTresholdValue = context.getProperty(CONTENT_REPO_THRESHOLD).getValue();
        Matcher contentRepoMatcher = PERCENT_PATTERN.matcher(contentRepoTresholdValue.trim());
        contentRepoMatcher.find();
        String contentRepoPercentageVal = contentRepoMatcher.group(1);
        int contentRepoThreshold = Integer.parseInt(contentRepoPercentageVal);
        String flowfileRepoTresholdValue = context.getProperty(FLOWFILE_REPO_THRESHOLD).getValue();
        Matcher flowFileRepoMatcher = PERCENT_PATTERN.matcher(flowfileRepoTresholdValue.trim());
        flowFileRepoMatcher.find();
        String flowFileRepoPercentageVal = flowFileRepoMatcher.group(1);
        int flowFileRepoThreshold = Integer.parseInt(flowFileRepoPercentageVal);
        NiFiProperties properties = NiFiProperties.getInstance();
        for (Map.Entry entry : properties.getContentRepositoryPaths().entrySet()) {
            MonitorDiskUsage.checkThreshold("Content Repository (" + (String)entry.getKey() + ")", (Path)entry.getValue(), contentRepoThreshold, context);
        }
        MonitorDiskUsage.checkThreshold("FlowFile Repository", properties.getFlowFileRepositoryPath(), flowFileRepoThreshold, context);
    }

    static void checkThreshold(String pathName, Path path, int threshold, ReportingContext context) {
        long freeBytes;
        File file = path.toFile();
        long totalBytes = file.getTotalSpace();
        long usedBytes = totalBytes - (freeBytes = file.getFreeSpace());
        double usedPercent = (double)usedBytes / (double)totalBytes * 100.0;
        if (usedPercent >= (double)threshold) {
            String usedSpace = FormatUtils.formatDataSize((double)usedBytes);
            String totalSpace = FormatUtils.formatDataSize((double)totalBytes);
            String freeSpace = FormatUtils.formatDataSize((double)freeBytes);
            double freePercent = (double)freeBytes / (double)totalBytes * 100.0;
            String message = String.format("%1$s exceeds configured threshold of %2$s%%, having %3$s / %4$s (%5$.2f%%) used and %6$s (%7$.2f%%) free", pathName, threshold, usedSpace, totalSpace, usedPercent, freeSpace, freePercent);
            Bulletin bulletin = context.createBulletin("Disk Usage", Severity.WARNING, message);
            context.getBulletinRepository().addBulletin(bulletin);
            logger.warn(message);
        }
    }
}

