/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"stats", "log"})
@CapabilityDescription(value="Logs the 5-minute stats that are shown in the NiFi Summary Page for Processors and Connections, as well optionally logging the deltas between the previous iteration and the current iteration. Processors' stats are logged using the org.apache.nifi.controller.ControllerStatusReportingTask.Processors logger, while Connections' stats are logged using the org.apache.nifi.controller.ControllerStatusReportingTask.Connections logger. These can be configured in the NiFi logging configuration to log to different files, if desired.")
public class ControllerStatusReportingTask
extends AbstractReportingTask {
    public static final PropertyDescriptor SHOW_DELTAS = new PropertyDescriptor.Builder().name("Show Deltas").description("Specifies whether or not to show the difference in values between the current status and the previous status").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    private static final Logger processorLogger = LoggerFactory.getLogger((String)(ControllerStatusReportingTask.class.getSimpleName() + ".Processors"));
    private static final Logger connectionLogger = LoggerFactory.getLogger((String)(ControllerStatusReportingTask.class.getSimpleName() + ".Connections"));
    private static final String PROCESSOR_LINE_FORMAT_NO_DELTA = "| %1$-30.30s | %2$-36.36s | %3$-24.24s | %4$10.10s | %5$19.19s | %6$19.19s | %7$12.12s | %8$13.13s | %9$5.5s | %10$12.12s |\n";
    private static final String PROCESSOR_LINE_FORMAT_WITH_DELTA = "| %1$-30.30s | %2$-36.36s | %3$-24.24s | %4$10.10s | %5$43.43s | %6$43.43s | %7$28.28s | %8$30.30s | %9$14.14s | %10$28.28s |\n";
    private static final String CONNECTION_LINE_FORMAT_NO_DELTA = "| %1$-36.36s | %2$-30.30s | %3$-36.36s | %4$-30.30s | %5$19.19s | %6$19.19s | %7$19.19s |\n";
    private static final String CONNECTION_LINE_FORMAT_WITH_DELTA = "| %1$-36.36s | %2$-30.30s | %3$-36.36s | %4$-30.30s | %5$43.43s | %6$43.43s | %7$43.43s |\n";
    private volatile String processorLineFormat;
    private volatile String processorHeader;
    private volatile String processorBorderLine;
    private volatile String connectionLineFormat;
    private volatile String connectionHeader;
    private volatile String connectionBorderLine;
    private volatile Map<String, ProcessorStatus> lastProcessorStatus = new HashMap<String, ProcessorStatus>();
    private volatile Map<String, ConnectionStatus> lastConnectionStatus = new HashMap<String, ConnectionStatus>();

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(SHOW_DELTAS);
        return descriptors;
    }

    @OnScheduled
    public void onConfigured(ConfigurationContext context) {
        this.connectionLineFormat = context.getProperty(SHOW_DELTAS).asBoolean() != false ? CONNECTION_LINE_FORMAT_WITH_DELTA : CONNECTION_LINE_FORMAT_NO_DELTA;
        this.connectionHeader = String.format(this.connectionLineFormat, "Connection ID", "Source", "Connection Name", "Destination", "Flow Files In", "Flow Files Out", "FlowFiles Queued");
        StringBuilder connectionBorderBuilder = new StringBuilder(this.connectionHeader.length());
        for (int i = 0; i < this.connectionHeader.length(); ++i) {
            connectionBorderBuilder.append('-');
        }
        this.connectionBorderLine = connectionBorderBuilder.toString();
        this.processorLineFormat = context.getProperty(SHOW_DELTAS).asBoolean() != false ? PROCESSOR_LINE_FORMAT_WITH_DELTA : PROCESSOR_LINE_FORMAT_NO_DELTA;
        this.processorHeader = String.format(this.processorLineFormat, "Processor Name", "Processor ID", "Processor Type", "Run Status", "Flow Files In", "Flow Files Out", "Bytes Read", "Bytes Written", "Tasks", "Proc Time");
        StringBuilder processorBorderBuilder = new StringBuilder(this.processorHeader.length());
        for (int i = 0; i < this.processorHeader.length(); ++i) {
            processorBorderBuilder.append('-');
        }
        this.processorBorderLine = processorBorderBuilder.toString();
    }

    public void onTrigger(ReportingContext context) {
        ProcessGroupStatus controllerStatus = context.getEventAccess().getControllerStatus();
        controllerStatus.clone();
        boolean showDeltas = context.getProperty(SHOW_DELTAS).asBoolean();
        StringBuilder builder = new StringBuilder();
        builder.append("Processor Statuses:\n");
        builder.append(this.processorBorderLine);
        builder.append("\n");
        builder.append(this.processorHeader);
        builder.append(this.processorBorderLine);
        builder.append("\n");
        this.printProcessorStatus(controllerStatus, builder, showDeltas);
        builder.append(this.processorBorderLine);
        processorLogger.info(builder.toString());
        builder.setLength(0);
        builder.append("Connection Statuses:\n");
        builder.append(this.connectionBorderLine);
        builder.append("\n");
        builder.append(this.connectionHeader);
        builder.append(this.connectionBorderLine);
        builder.append("\n");
        this.printConnectionStatus(controllerStatus, builder, showDeltas);
        builder.append(this.connectionBorderLine);
        connectionLogger.info(builder.toString());
    }

    private void populateConnectionStatuses(ProcessGroupStatus groupStatus, List<ConnectionStatus> statuses) {
        statuses.addAll(groupStatus.getConnectionStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateConnectionStatuses(childGroupStatus, statuses);
        }
    }

    private void populateProcessorStatuses(ProcessGroupStatus groupStatus, List<ProcessorStatus> statuses) {
        statuses.addAll(groupStatus.getProcessorStatus());
        for (ProcessGroupStatus childGroupStatus : groupStatus.getProcessGroupStatus()) {
            this.populateProcessorStatuses(childGroupStatus, statuses);
        }
    }

    private void printConnectionStatus(ProcessGroupStatus groupStatus, StringBuilder builder, boolean showDeltas) {
        ArrayList<ConnectionStatus> connectionStatuses = new ArrayList<ConnectionStatus>();
        this.populateConnectionStatuses(groupStatus, connectionStatuses);
        Collections.sort(connectionStatuses, new Comparator<ConnectionStatus>(){

            @Override
            public int compare(ConnectionStatus o1, ConnectionStatus o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -Long.compare(o1.getQueuedBytes(), o2.getQueuedBytes());
            }
        });
        for (ConnectionStatus connectionStatus : connectionStatuses) {
            String queuedDiff;
            String outputDiff;
            String inputDiff;
            String input = connectionStatus.getInputCount() + " / " + FormatUtils.formatDataSize((double)connectionStatus.getInputBytes());
            String output = connectionStatus.getOutputCount() + " / " + FormatUtils.formatDataSize((double)connectionStatus.getOutputBytes());
            String queued = connectionStatus.getQueuedCount() + " / " + FormatUtils.formatDataSize((double)connectionStatus.getQueuedBytes());
            ConnectionStatus lastStatus = this.lastConnectionStatus.get(connectionStatus.getId());
            if (showDeltas && lastStatus != null) {
                inputDiff = this.toDiff((long)lastStatus.getInputCount(), lastStatus.getInputBytes(), connectionStatus.getInputCount(), connectionStatus.getInputBytes());
                outputDiff = this.toDiff((long)lastStatus.getOutputCount(), lastStatus.getOutputBytes(), connectionStatus.getOutputCount(), connectionStatus.getOutputBytes());
                queuedDiff = this.toDiff((long)lastStatus.getQueuedCount(), lastStatus.getQueuedBytes(), connectionStatus.getQueuedCount(), connectionStatus.getQueuedBytes());
            } else {
                inputDiff = this.toDiff(0L, 0L, connectionStatus.getInputCount(), connectionStatus.getInputBytes());
                outputDiff = this.toDiff(0L, 0L, connectionStatus.getOutputCount(), connectionStatus.getOutputBytes());
                queuedDiff = this.toDiff(0L, 0L, connectionStatus.getQueuedCount(), connectionStatus.getQueuedBytes());
            }
            if (showDeltas) {
                builder.append(String.format(this.connectionLineFormat, connectionStatus.getId(), connectionStatus.getSourceName(), connectionStatus.getName(), connectionStatus.getDestinationName(), input + inputDiff, output + outputDiff, queued + queuedDiff));
            } else {
                builder.append(String.format(this.connectionLineFormat, connectionStatus.getId(), connectionStatus.getSourceName(), connectionStatus.getName(), connectionStatus.getDestinationName(), input, output, queued));
            }
            this.lastConnectionStatus.put(connectionStatus.getId(), connectionStatus);
        }
    }

    private String toDiff(long oldValue, long newValue) {
        return this.toDiff(oldValue, newValue, false, false);
    }

    private String toDiff(long oldValue, long newValue, boolean formatDataSize, boolean formatTime) {
        String formattedDiff;
        if (formatDataSize && formatTime) {
            throw new IllegalArgumentException("Cannot format units as both data size and time");
        }
        long diff = Math.abs(newValue - oldValue);
        String string = formatDataSize ? FormatUtils.formatDataSize((double)diff) : (formattedDiff = formatTime ? FormatUtils.formatHoursMinutesSeconds((long)diff, (TimeUnit)TimeUnit.NANOSECONDS) : String.valueOf(diff));
        if (oldValue > newValue) {
            return " (-" + formattedDiff + ")";
        }
        return " (+" + formattedDiff + ")";
    }

    private String toDiff(long oldCount, long oldBytes, long newCount, long newBytes) {
        long countDiff = Math.abs(newCount - oldCount);
        long bytesDiff = Math.abs(newBytes - oldBytes);
        StringBuilder sb = new StringBuilder();
        sb.append(" (").append(oldCount > newCount ? "-" : "+").append(countDiff).append("/");
        sb.append(oldBytes > newBytes ? "-" : "+");
        sb.append(FormatUtils.formatDataSize((double)bytesDiff)).append(")");
        return sb.toString();
    }

    private void printProcessorStatus(ProcessGroupStatus groupStatus, StringBuilder builder, boolean showDeltas) {
        ArrayList<ProcessorStatus> processorStatuses = new ArrayList<ProcessorStatus>();
        this.populateProcessorStatuses(groupStatus, processorStatuses);
        Collections.sort(processorStatuses, new Comparator<ProcessorStatus>(){

            @Override
            public int compare(ProcessorStatus o1, ProcessorStatus o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return -Long.compare(o1.getProcessingNanos(), o2.getProcessingNanos());
            }
        });
        for (ProcessorStatus processorStatus : processorStatuses) {
            String procTimeDiff;
            String invocationsDiff;
            String writtenDiff;
            String readDiff;
            String outputDiff;
            String inputDiff;
            String input = processorStatus.getInputCount() + " / " + FormatUtils.formatDataSize((double)processorStatus.getInputBytes());
            String output = processorStatus.getOutputCount() + " / " + FormatUtils.formatDataSize((double)processorStatus.getOutputBytes());
            String read = FormatUtils.formatDataSize((double)processorStatus.getBytesRead());
            String written = FormatUtils.formatDataSize((double)processorStatus.getBytesWritten());
            String invocations = String.valueOf(processorStatus.getInvocations());
            long nanos = processorStatus.getProcessingNanos();
            String procTime = FormatUtils.formatHoursMinutesSeconds((long)nanos, (TimeUnit)TimeUnit.NANOSECONDS);
            String runStatus = "";
            if (processorStatus.getRunStatus() != null) {
                runStatus = processorStatus.getRunStatus().toString();
            }
            ProcessorStatus lastStatus = this.lastProcessorStatus.get(processorStatus.getId());
            if (showDeltas && lastStatus != null) {
                inputDiff = this.toDiff((long)lastStatus.getInputCount(), lastStatus.getInputBytes(), processorStatus.getInputCount(), processorStatus.getInputBytes());
                outputDiff = this.toDiff((long)lastStatus.getOutputCount(), lastStatus.getOutputBytes(), processorStatus.getOutputCount(), processorStatus.getOutputBytes());
                readDiff = this.toDiff(lastStatus.getBytesRead(), processorStatus.getBytesRead(), true, false);
                writtenDiff = this.toDiff(lastStatus.getBytesWritten(), processorStatus.getBytesWritten(), true, false);
                invocationsDiff = this.toDiff(lastStatus.getInvocations(), processorStatus.getInvocations());
                procTimeDiff = this.toDiff(lastStatus.getProcessingNanos(), processorStatus.getProcessingNanos(), false, true);
            } else {
                inputDiff = this.toDiff(0L, 0L, processorStatus.getInputCount(), processorStatus.getInputBytes());
                outputDiff = this.toDiff(0L, 0L, processorStatus.getOutputCount(), processorStatus.getOutputBytes());
                readDiff = this.toDiff(0L, processorStatus.getBytesRead(), true, false);
                writtenDiff = this.toDiff(0L, processorStatus.getBytesWritten(), true, false);
                invocationsDiff = this.toDiff(0L, processorStatus.getInvocations());
                procTimeDiff = this.toDiff(0L, processorStatus.getProcessingNanos(), false, true);
            }
            if (showDeltas) {
                builder.append(String.format(this.processorLineFormat, processorStatus.getName(), processorStatus.getId(), processorStatus.getType(), runStatus, input + inputDiff, output + outputDiff, read + readDiff, written + writtenDiff, invocations + invocationsDiff, procTime + procTimeDiff));
            } else {
                builder.append(String.format(this.processorLineFormat, processorStatus.getName(), processorStatus.getId(), processorStatus.getType(), runStatus, input, output, read, written, invocations, procTime));
            }
            this.lastProcessorStatus.put(processorStatus.getId(), processorStatus);
        }
    }
}

