/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.nifi.logging.ProcessorLog;

public class WrappedMessageProducer {
    private final Connection connection;
    private final Session session;
    private final MessageProducer producer;
    private boolean closed = false;

    public WrappedMessageProducer(Connection connection, Session jmsSession, MessageProducer messageProducer) {
        this.connection = connection;
        this.session = jmsSession;
        this.producer = messageProducer;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public void close(ProcessorLog logger) {
        this.closed = true;
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            logger.warn("unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", (Throwable)e);
        }
        try {
            this.session.close();
        }
        catch (JMSException e) {
            logger.warn("unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", (Throwable)e);
        }
        try {
            this.producer.close();
        }
        catch (JMSException e) {
            logger.warn("unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

