/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public final class SocksProxySocketFactory
extends SocketFactory {
    private final Proxy proxy;

    public SocksProxySocketFactory(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Socket createSocket() throws IOException {
        return new Socket(this.proxy);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(addr, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress localHostAddr, int localPort) throws IOException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHostAddr, localPort));
        socket.connect(new InetSocketAddress(addr, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHostAddr, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localHostAddr, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }
}

