/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.SFTPConnection;

public class SFTPUtils {
    public static final PropertyDescriptor SFTP_PRIVATEKEY_PATH = new PropertyDescriptor.Builder().required(false).description("sftp.privatekey.path").defaultValue(null).name("sftp.privatekey.path").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor REMOTE_PASSWORD = new PropertyDescriptor.Builder().required(false).description("remote.password").defaultValue(null).name("remote.password").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SFTP_PRIVATEKEY_PASSPHRASE = new PropertyDescriptor.Builder().required(false).description("sftp.privatekey.passphrase").defaultValue(null).name("sftp.privatekey.passphrase").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor SFTP_PORT = new PropertyDescriptor.Builder().required(false).description("sftp.port").defaultValue(null).name("sftp.port").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor NETWORK_DATA_TIMEOUT = new PropertyDescriptor.Builder().required(false).description("network.data.timeout").defaultValue(null).name("network.data.timeout").addValidator(StandardValidators.INTEGER_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor SFTP_HOSTKEY_FILENAME = new PropertyDescriptor.Builder().required(false).description("sftp.hostkey.filename").defaultValue(null).name("sftp.hostkey.filename").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor NETWORK_CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().required(false).description("network.connection.timeout").defaultValue(null).name("network.connection.timeout").addValidator(StandardValidators.INTEGER_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor REMOTE_HOSTNAME = new PropertyDescriptor.Builder().required(true).description("remote.hostname").defaultValue(null).name("remote.hostname").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor REMOTE_USERNAME = new PropertyDescriptor.Builder().required(true).description("remote.username").defaultValue(null).name("remote.username").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(false).build();
    private static final List<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
    private static final Log logger;

    public static List<PropertyDescriptor> getPropertyDescriptors() {
        return propertyDescriptors;
    }

    public static SFTPConnection connectSftp(SFTPConfiguration conf) throws JSchException, SftpException, IOException {
        JSch jsch = new JSch();
        Session session = SFTPUtils.createSession(conf, jsch);
        ChannelSftp sftp = (ChannelSftp)session.openChannel("sftp");
        sftp.connect();
        return new SFTPConnection(session, sftp);
    }

    public static void changeWorkingDirectory(ChannelSftp sftp, String dirPath, boolean createDirs, Processor proc) throws IOException {
        LinkedList<String> stack = new LinkedList<String>();
        File dir = new File(dirPath);
        String currentWorkingDirectory = null;
        boolean dirExists = false;
        String forwardPaths = dir.getPath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("/"));
        try {
            currentWorkingDirectory = sftp.pwd();
            logger.debug((Object)(proc + " attempting to change directory from " + currentWorkingDirectory + " to " + dir.getPath()));
            sftp.cd(forwardPaths);
            dirExists = true;
            logger.debug((Object)(proc + " changed working directory to '" + forwardPaths + "' from '" + currentWorkingDirectory + "'"));
        }
        catch (SftpException sftpe) {
            logger.debug((Object)(proc + " could not change directory to '" + forwardPaths + "' from '" + currentWorkingDirectory + "' so trying the hard way."));
        }
        if (dirExists) {
            return;
        }
        if (!createDirs) {
            throw new IOException("Unable to change to requested working directory '" + forwardPaths + "' but not configured to create dirs.");
        }
        do {
            stack.push(dir.getName());
        } while ((dir = dir.getParentFile()) != null);
        String dirName = null;
        while ((dirName = (String)stack.peek()) != null) {
            stack.pop();
            dirName = "".equals(dirName.trim()) ? "/" : dirName;
            try {
                sftp.cd(dirName);
            }
            catch (SftpException sftpe) {
                logger.debug((Object)(proc + " creating new directory and changing to it " + dirName));
                try {
                    sftp.mkdir(dirName);
                    sftp.cd(dirName);
                }
                catch (SftpException e) {
                    throw new IOException(proc + " could not make/change directory to [" + dirName + "] [" + e.getLocalizedMessage() + "]", e);
                }
            }
        }
    }

    public static Session createSession(SFTPConfiguration conf, JSch jsch) throws JSchException, IOException {
        if (conf == null || null == jsch) {
            throw new NullPointerException();
        }
        Hashtable<String, String> newOptions = new Hashtable<String, String>();
        Session session = jsch.getSession(conf.username, conf.hostname, conf.port);
        String hostKeyVal = conf.hostkeyFile;
        if (null != hostKeyVal) {
            try {
                jsch.setKnownHosts(hostKeyVal);
            }
            catch (IndexOutOfBoundsException iob) {
                throw new IOException("Unable to establish connection due to bad known hosts key file " + hostKeyVal, iob);
            }
        } else {
            newOptions.put("StrictHostKeyChecking", "no");
            session.setConfig(newOptions);
        }
        String privateKeyVal = conf.privatekeyFile;
        if (null != privateKeyVal) {
            jsch.addIdentity(privateKeyVal, conf.privateKeypassphrase);
        }
        if (null != conf.password) {
            session.setPassword(conf.password);
        }
        session.setTimeout(conf.connectionTimeout);
        session.connect();
        session.setTimeout(conf.dataTimeout);
        return session;
    }

    public static Logger createLogger() {
        return new Logger(){

            public boolean isEnabled(int level) {
                return true;
            }

            public void log(int level, String message) {
                logger.debug((Object)("SFTP Log: " + message));
            }
        };
    }

    static {
        JSch.setLogger((Logger)SFTPUtils.createLogger());
        propertyDescriptors.add(SFTP_PRIVATEKEY_PATH);
        propertyDescriptors.add(REMOTE_PASSWORD);
        propertyDescriptors.add(SFTP_PRIVATEKEY_PASSPHRASE);
        propertyDescriptors.add(SFTP_PORT);
        propertyDescriptors.add(NETWORK_DATA_TIMEOUT);
        propertyDescriptors.add(SFTP_HOSTKEY_FILENAME);
        propertyDescriptors.add(NETWORK_CONNECTION_TIMEOUT);
        propertyDescriptors.add(REMOTE_USERNAME);
        propertyDescriptors.add(REMOTE_HOSTNAME);
        logger = LogFactory.getLog(SFTPUtils.class);
    }

    public static class SFTPConfiguration {
        private String hostname;
        private String username;
        private int port = 22;
        private int connectionTimeout = 0;
        private int dataTimeout = 0;
        private String hostkeyFile;
        private String privatekeyFile;
        private String password;
        private String privateKeypassphrase;

        public void setHostname(String val) {
            this.hostname = val;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setUsername(String val) {
            this.username = val;
        }

        public String getUsername() {
            return this.username;
        }

        public void setPort(String val) {
            if (val != null) {
                this.port = Integer.parseInt(val);
            }
        }

        public void setConnectionTimeout(String val) {
            if (val != null) {
                this.connectionTimeout = Integer.parseInt(val);
            }
        }

        public void setDataTimeout(String val) {
            if (val != null) {
                this.dataTimeout = Integer.parseInt(val);
            }
        }

        public void setHostkeyFile(String val) {
            this.hostkeyFile = val;
        }

        public void setPrivateKeyFile(String val) {
            this.privatekeyFile = val;
        }

        public void setPassword(String val) {
            this.password = val;
        }

        public void setPrivateKeyPassphrase(String val) {
            this.privateKeypassphrase = val;
        }
    }
}

