/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.PutFileTransfer;
import org.apache.nifi.processors.standard.util.FTPTransfer;

@SupportsBatching
@Tags(value={"remote", "copy", "egress", "put", "ftp", "archive", "files"})
@CapabilityDescription(value="Sends FlowFiles to an FTP Server")
public class PutFTP
extends PutFileTransfer<FTPTransfer> {
    private static final Pattern PRE_SEND_CMD_PATTERN = Pattern.compile("^pre\\.cmd\\.(\\d+)$");
    private static final Pattern POST_SEND_CMD_PATTERN = Pattern.compile("^post\\.cmd\\.(\\d+)$");
    private final AtomicReference<List<PropertyDescriptor>> preSendDescriptorRef = new AtomicReference();
    private final AtomicReference<List<PropertyDescriptor>> postSendDescriptorRef = new AtomicReference();
    private List<PropertyDescriptor> properties;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(FTPTransfer.HOSTNAME);
        properties.add(FTPTransfer.PORT);
        properties.add(FTPTransfer.USERNAME);
        properties.add(FTPTransfer.PASSWORD);
        properties.add(FTPTransfer.REMOTE_PATH);
        properties.add(FTPTransfer.CREATE_DIRECTORY);
        properties.add(FTPTransfer.BATCH_SIZE);
        properties.add(FTPTransfer.CONNECTION_TIMEOUT);
        properties.add(FTPTransfer.DATA_TIMEOUT);
        properties.add(FTPTransfer.CONFLICT_RESOLUTION);
        properties.add(FTPTransfer.DOT_RENAME);
        properties.add(FTPTransfer.TEMP_FILENAME);
        properties.add(FTPTransfer.TRANSFER_MODE);
        properties.add(FTPTransfer.CONNECTION_MODE);
        properties.add(FTPTransfer.REJECT_ZERO_BYTE);
        properties.add(FTPTransfer.LAST_MODIFIED_TIME);
        properties.add(FTPTransfer.PERMISSIONS);
        properties.add(FTPTransfer.USE_COMPRESSION);
        properties.add(FTPTransfer.PROXY_TYPE);
        properties.add(FTPTransfer.PROXY_HOST);
        properties.add(FTPTransfer.PROXY_PORT);
        properties.add(FTPTransfer.HTTP_PROXY_USERNAME);
        properties.add(FTPTransfer.HTTP_PROXY_PASSWORD);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @Override
    protected void beforePut(FlowFile flowFile, ProcessContext context, FTPTransfer transfer) throws IOException {
        transfer.sendCommands(this.getCommands(this.preSendDescriptorRef.get(), context, flowFile), flowFile);
    }

    @Override
    protected void afterPut(FlowFile flowFile, ProcessContext context, FTPTransfer transfer) throws IOException {
        transfer.sendCommands(this.getCommands(this.postSendDescriptorRef.get(), context, flowFile), flowFile);
    }

    @Override
    protected FTPTransfer getFileTransfer(ProcessContext context) {
        return new FTPTransfer(context, this.getLogger());
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).build();
    }

    @OnScheduled
    public void determinePrePostSendProperties(ProcessContext context) {
        TreeMap<Integer, PropertyDescriptor> preDescriptors = new TreeMap<Integer, PropertyDescriptor>();
        TreeMap<Integer, PropertyDescriptor> postDescriptors = new TreeMap<Integer, PropertyDescriptor>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            String name = descriptor.getName();
            Matcher preMatcher = PRE_SEND_CMD_PATTERN.matcher(name);
            if (preMatcher.matches()) {
                int index = Integer.parseInt(preMatcher.group(1));
                preDescriptors.put(index, descriptor);
                continue;
            }
            Matcher postMatcher = POST_SEND_CMD_PATTERN.matcher(name);
            if (!postMatcher.matches()) continue;
            int index = Integer.parseInt(postMatcher.group(1));
            postDescriptors.put(index, descriptor);
        }
        ArrayList preDescriptorList = new ArrayList(preDescriptors.values());
        ArrayList postDescriptorList = new ArrayList(postDescriptors.values());
        this.preSendDescriptorRef.set(preDescriptorList);
        this.postSendDescriptorRef.set(postDescriptorList);
    }

    private List<String> getCommands(List<PropertyDescriptor> descriptors, ProcessContext context, FlowFile flowFile) {
        ArrayList<String> cmds = new ArrayList<String>();
        for (PropertyDescriptor descriptor : descriptors) {
            cmds.add(context.getProperty(descriptor).evaluateAttributeExpressions(flowFile).getValue());
        }
        return cmds;
    }
}

