/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.JmsConsumer;
import org.apache.nifi.processors.standard.util.JmsFactory;
import org.apache.nifi.processors.standard.util.JmsProperties;
import org.apache.nifi.processors.standard.util.WrappedMessageConsumer;

@TriggerSerially
@TriggerWhenEmpty
@Tags(value={"jms", "topic", "subscription", "durable", "non-durable", "listen", "get", "pull", "source", "consume", "consumer"})
@CapabilityDescription(value="Pulls messages from a JMS Topic, creating a FlowFile for each JMS Message or bundle of messages, as configured")
public class GetJMSTopic
extends JmsConsumer {
    public static final String SUBSCRIPTION_NAME_PROPERTY = "subscription.name";
    private volatile WrappedMessageConsumer wrappedConsumer = null;
    private final List<PropertyDescriptor> properties;

    public GetJMSTopic() {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        props.add(JmsProperties.DURABLE_SUBSCRIPTION);
        this.properties = Collections.unmodifiableList(props);
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnStopped
    public void cleanupResources() {
        WrappedMessageConsumer consumer = this.wrappedConsumer;
        if (consumer != null) {
            try {
                consumer.close(this.getLogger());
            }
            finally {
                this.wrappedConsumer = null;
            }
        }
    }

    private Path getSubscriptionPath() {
        return Paths.get("conf", new String[0]).resolve("jms-subscription-" + this.getIdentifier());
    }

    @OnScheduled
    public void handleSubscriptions(ProcessContext context) throws IOException, JMSException {
        boolean usingDurableSubscription = context.getProperty(JmsProperties.DURABLE_SUBSCRIPTION).asBoolean();
        Properties persistedProps = this.getSubscriptionPropertiesFromFile();
        Properties currentProps = this.getSubscriptionPropertiesFromContext(context);
        if (persistedProps == null) {
            if (usingDurableSubscription) {
                this.persistSubscriptionInfo(context);
            }
            return;
        }
        this.decryptPassword(persistedProps, context);
        this.decryptPassword(currentProps, context);
        boolean same = true;
        for (Map.Entry<Object, Object> entry : persistedProps.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object curVal = currentProps.get(key);
            if (value == null && curVal == null) continue;
            if (value == null || curVal == null) {
                same = false;
                break;
            }
            if (SUBSCRIPTION_NAME_PROPERTY.equals(key)) {
                if (JmsFactory.clientIdPrefixEquals(value.toString(), curVal.toString())) continue;
                same = false;
                break;
            }
            if (value.equals(curVal)) continue;
            same = false;
            break;
        }
        if (same && usingDurableSubscription) {
            return;
        }
        try {
            this.unsubscribe(context);
        }
        catch (InvalidDestinationException e) {
            this.getLogger().warn("Failed to unsubscribe from subscription due to {}; subscription does not appear to be active, so ignoring it", new Object[]{e});
        }
        if (usingDurableSubscription) {
            this.persistSubscriptionInfo(context);
        } else {
            try {
                Files.delete(this.getSubscriptionPath());
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public void decryptPassword(Properties properties, ProcessContext context) {
        String encryptedPassword = properties.getProperty(JmsProperties.PASSWORD.getName());
        if (encryptedPassword != null) {
            properties.put(JmsProperties.PASSWORD.getName(), context.decrypt(encryptedPassword));
        }
    }

    @OnRemoved
    public void onRemoved(ProcessContext context) throws IOException, JMSException {
        this.unsubscribe(context);
    }

    private void persistSubscriptionInfo(ProcessContext context) throws IOException {
        Properties props = this.getSubscriptionPropertiesFromContext(context);
        try (OutputStream out = Files.newOutputStream(this.getSubscriptionPath(), new OpenOption[0]);){
            props.store(out, null);
        }
    }

    private Properties getSubscriptionPropertiesFromContext(ProcessContext context) {
        String unencryptedPassword = context.getProperty(JmsProperties.PASSWORD).getValue();
        String encryptedPassword = unencryptedPassword == null ? null : context.encrypt(unencryptedPassword);
        Properties props = new Properties();
        props.setProperty(JmsProperties.URL.getName(), context.getProperty(JmsProperties.URL).getValue());
        if (context.getProperty(JmsProperties.USERNAME).isSet()) {
            props.setProperty(JmsProperties.USERNAME.getName(), context.getProperty(JmsProperties.USERNAME).getValue());
        }
        if (encryptedPassword != null) {
            props.setProperty(JmsProperties.PASSWORD.getName(), encryptedPassword);
        }
        props.setProperty(SUBSCRIPTION_NAME_PROPERTY, JmsFactory.createClientId(context));
        props.setProperty(JmsProperties.JMS_PROVIDER.getName(), context.getProperty(JmsProperties.JMS_PROVIDER).getValue());
        if (context.getProperty(JmsProperties.CLIENT_ID_PREFIX).isSet()) {
            props.setProperty(JmsProperties.CLIENT_ID_PREFIX.getName(), context.getProperty(JmsProperties.CLIENT_ID_PREFIX).getValue());
        }
        return props;
    }

    private Properties getSubscriptionPropertiesFromFile() throws IOException {
        Path subscriptionPath = this.getSubscriptionPath();
        boolean exists = Files.exists(subscriptionPath, new LinkOption[0]);
        if (!exists) {
            return null;
        }
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(subscriptionPath, new OpenOption[0]);){
            props.load(in);
        }
        return props;
    }

    private void unsubscribe(ProcessContext context) throws IOException, JMSException {
        Properties props = this.getSubscriptionPropertiesFromFile();
        if (props == null) {
            return;
        }
        String serverUrl = props.getProperty(JmsProperties.URL.getName());
        String username = props.getProperty(JmsProperties.USERNAME.getName());
        String encryptedPassword = props.getProperty(JmsProperties.PASSWORD.getName());
        String subscriptionName = props.getProperty(SUBSCRIPTION_NAME_PROPERTY);
        String jmsProvider = props.getProperty(JmsProperties.JMS_PROVIDER.getName());
        String password = encryptedPassword == null ? null : context.decrypt(encryptedPassword);
        int timeoutMillis = context.getProperty(JmsProperties.TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        this.unsubscribe(serverUrl, username, password, subscriptionName, jmsProvider, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe(String url, String username, String password, String subscriptionId, String jmsProvider, int timeoutMillis) throws JMSException {
        Connection connection;
        block11: {
            connection = username == null && password == null ? JmsFactory.createConnectionFactory(url, timeoutMillis, jmsProvider).createConnection() : JmsFactory.createConnectionFactory(url, timeoutMillis, jmsProvider).createConnection(username, password);
            Session session = null;
            try {
                connection.setClientID(subscriptionId);
                session = connection.createSession(false, 1);
                session.unsubscribe(subscriptionId);
                this.getLogger().info("Successfully unsubscribed from {}, Subscription Identifier {}", new Object[]{url, subscriptionId});
                if (session == null) break block11;
            }
            catch (Throwable throwable) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception e1) {
                        this.getLogger().warn("Unable to close session with JMS Server due to {}; resources may not be cleaned up appropriately", new Object[]{e1});
                    }
                }
                try {
                    connection.close();
                }
                catch (Exception e1) {
                    this.getLogger().warn("Unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", new Object[]{e1});
                }
                throw throwable;
            }
            try {
                session.close();
            }
            catch (Exception e1) {
                this.getLogger().warn("Unable to close session with JMS Server due to {}; resources may not be cleaned up appropriately", new Object[]{e1});
            }
        }
        try {
            connection.close();
        }
        catch (Exception e1) {
            this.getLogger().warn("Unable to close connection to JMS Server due to {}; resources may not be cleaned up appropriately", new Object[]{e1});
        }
    }

    @OnStopped
    public void onStopped() {
        WrappedMessageConsumer consumer = this.wrappedConsumer;
        if (consumer != null) {
            consumer.close(this.getLogger());
            this.wrappedConsumer = null;
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        ProcessorLog logger = this.getLogger();
        WrappedMessageConsumer consumer = this.wrappedConsumer;
        if (consumer == null || consumer.isClosed()) {
            try {
                Properties props = null;
                try {
                    props = this.getSubscriptionPropertiesFromFile();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                if (props == null) {
                    props = this.getSubscriptionPropertiesFromContext(context);
                }
                String subscriptionName = props.getProperty(SUBSCRIPTION_NAME_PROPERTY);
                this.wrappedConsumer = consumer = JmsFactory.createTopicMessageConsumer(context, subscriptionName);
            }
            catch (JMSException e) {
                logger.error("Failed to connect to JMS Server due to {}", new Object[]{e});
                context.yield();
                return;
            }
        }
        super.consume(context, session, consumer);
    }
}

