/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"encryption", "decryption", "password", "JCE"})
@CapabilityDescription(value="Encrypts or Decrypts a FlowFile using a randomly generated salt")
public class EncryptContent
extends AbstractProcessor {
    public static final String ENCRYPT_MODE = "Encrypt";
    public static final String DECRYPT_MODE = "Decrypt";
    public static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    public static final int DEFAULT_SALT_SIZE = 8;
    public static final PropertyDescriptor MODE = new PropertyDescriptor.Builder().name("Mode").description("Specifies whether the content should be encrypted or decrypted").required(true).allowableValues(new String[]{"Encrypt", "Decrypt"}).defaultValue("Encrypt").build();
    public static final PropertyDescriptor ENCRYPTION_ALGORITHM = new PropertyDescriptor.Builder().name("Encryption Algorithm").description("The Encryption Algorithm to use").required(true).allowableValues((Enum[])EncryptionMethod.values()).defaultValue(EncryptionMethod.MD5_256AES.name()).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The Password to use for encrypting or decrypting the data").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that is successfully encrypted or decrypted will be routed to success").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that cannot be encrypted or decrypted will be routed to failure").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(MODE);
        properties.add(ENCRYPTION_ALGORITHM);
        properties.add(PASSWORD);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        Cipher cipher;
        SecretKey secretKey;
        SecureRandom secureRandom;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ProcessorLog logger = this.getLogger();
        String method = context.getProperty(ENCRYPTION_ALGORITHM).getValue();
        EncryptionMethod encryptionMethod = EncryptionMethod.valueOf((String)method);
        String providerName = encryptionMethod.getProvider();
        String algorithm = encryptionMethod.getAlgorithm();
        String password = context.getProperty(PASSWORD).getValue();
        char[] normalizedPassword = Normalizer.normalize(password, Normalizer.Form.NFC).toCharArray();
        PBEKeySpec pbeKeySpec = new PBEKeySpec(normalizedPassword);
        try {
            secureRandom = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
            secureRandom.setSeed(System.currentTimeMillis());
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm, providerName);
            secretKey = factory.generateSecret(pbeKeySpec);
            cipher = Cipher.getInstance(algorithm, providerName);
        }
        catch (Exception e) {
            logger.error("failed to initialize Encryption/Decryption algorithm due to {}", new Object[]{e});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        int algorithmBlockSize = cipher.getBlockSize();
        int saltSize = algorithmBlockSize > 0 ? algorithmBlockSize : 8;
        StopWatch stopWatch = new StopWatch(true);
        if (context.getProperty(MODE).getValue().equalsIgnoreCase(ENCRYPT_MODE)) {
            byte[] salt = new byte[saltSize];
            secureRandom.nextBytes(salt);
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 1000);
            try {
                cipher.init(1, (Key)secretKey, parameterSpec);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                logger.error("unable to encrypt {} due to {}", new Object[]{flowFile, e});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            flowFile = session.write(flowFile, (StreamCallback)new EncryptCallback(cipher, salt));
            logger.info("Successfully encrypted {}", new Object[]{flowFile});
        } else {
            if (flowFile.getSize() <= (long)saltSize) {
                logger.error("Cannot decrypt {} because its file size is not greater than the salt size", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            flowFile = session.write(flowFile, (StreamCallback)new DecryptCallback(cipher, secretKey, saltSize));
            logger.info("successfully decrypted {}", new Object[]{flowFile});
        }
        session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
        session.transfer(flowFile, REL_SUCCESS);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static class EncryptCallback
    implements StreamCallback {
        private final Cipher cipher;
        private final byte[] salt;

        public EncryptCallback(Cipher cipher, byte[] salt) {
            this.cipher = cipher;
            this.salt = salt;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            out.write(this.salt);
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] encryptedBytes = this.cipher.update(buffer, 0, len);
                if (encryptedBytes == null) continue;
                out.write(encryptedBytes);
            }
            try {
                out.write(this.cipher.doFinal());
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }

    private static class DecryptCallback
    implements StreamCallback {
        private final Cipher cipher;
        private final SecretKey secretKey;
        private final int saltSize;

        public DecryptCallback(Cipher cipher, SecretKey secretKey, int saltSize) {
            this.cipher = cipher;
            this.secretKey = secretKey;
            this.saltSize = saltSize;
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            byte[] salt = new byte[this.saltSize];
            StreamUtils.fillBuffer((InputStream)in, (byte[])salt);
            PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 1000);
            try {
                this.cipher.init(2, (Key)this.secretKey, parameterSpec);
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            byte[] buffer = new byte[65536];
            while ((len = in.read(buffer)) > 0) {
                byte[] decryptedBytes = this.cipher.update(buffer, 0, len);
                if (decryptedBytes == null) continue;
                out.write(decryptedBytes);
            }
            try {
                out.write(this.cipher.doFinal());
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
        }
    }
}

