/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processors.standard.util.JsonPathExpressionValidator;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.util.ObjectHolder;

public abstract class AbstractJsonPathProcessor
extends AbstractProcessor {
    private static final Configuration STRICT_PROVIDER_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JsonSmartJsonProvider(912)).build();
    private static final JsonProvider JSON_PROVIDER = STRICT_PROVIDER_CONFIGURATION.jsonProvider();

    static DocumentContext validateAndEstablishJsonContext(ProcessSession processSession, FlowFile flowFile) {
        final ObjectHolder contextHolder = new ObjectHolder(null);
        processSession.read(flowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(in);){
                    DocumentContext ctx = JsonPath.using((Configuration)STRICT_PROVIDER_CONFIGURATION).parse((InputStream)bufferedInputStream);
                    contextHolder.set((Object)ctx);
                }
            }
        });
        return (DocumentContext)contextHolder.get();
    }

    static boolean isJsonScalar(Object obj) {
        return !(obj instanceof Map) && !(obj instanceof List);
    }

    static String getResultRepresentation(Object jsonPathResult) {
        if (AbstractJsonPathProcessor.isJsonScalar(jsonPathResult)) {
            return jsonPathResult.toString();
        }
        return JSON_PROVIDER.toJson(jsonPathResult);
    }

    static abstract class JsonPathValidator
    implements Validator {
        JsonPathValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String error = null;
            if (this.isStale(subject, input)) {
                if (JsonPathExpressionValidator.isValidExpression(input, new Predicate[0])) {
                    JsonPath compiledJsonPath = JsonPath.compile((String)input, (Predicate[])new Predicate[0]);
                    this.cacheComputedValue(subject, input, compiledJsonPath);
                } else {
                    error = "specified expression was not valid: " + input;
                }
            }
            return new ValidationResult.Builder().subject(subject).valid(error == null).explanation(error).build();
        }

        abstract void cacheComputedValue(String var1, String var2, JsonPath var3);

        abstract boolean isStale(String var1, String var2);
    }
}

