/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.prioritizer;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public class PriorityAttributePrioritizer
implements FlowFilePrioritizer {
    private static final Predicate<String> isInteger = Pattern.compile("-?\\d+").asMatchPredicate();
    private static final Comparator<String> priorityAttributeComparator = Comparator.nullsLast(Comparator.comparing(PriorityAttributePrioritizer::parseLongOrNull, Comparator.nullsLast(Long::compare)).thenComparing(Comparator.naturalOrder()));
    private static final Comparator<FlowFile> composedComparator = Comparator.nullsLast(Comparator.comparing(flowFile -> flowFile.getAttribute(CoreAttributes.PRIORITY.key()), priorityAttributeComparator));

    private static Long parseLongOrNull(String attribute) {
        String trimmedAttribute = attribute.trim();
        if (isInteger.test(trimmedAttribute)) {
            try {
                return Long.parseLong(trimmedAttribute);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    public int compare(FlowFile o1, FlowFile o2) {
        return composedComparator.compare(o1, o2);
    }
}

