/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ssl;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.TlsConfiguration;

@Tags(value={"ssl", "secure", "certificate", "keystore", "truststore", "jks", "p12", "pkcs12", "pkcs"})
@CapabilityDescription(value="Provides the ability to configure keystore and/or truststore properties once and reuse that configuration throughout the application")
public interface SSLContextService
extends ControllerService {
    public TlsConfiguration createTlsConfiguration();

    public SSLContext createContext();

    @Deprecated
    public SSLContext createSSLContext(org.apache.nifi.security.util.ClientAuth var1) throws ProcessException;

    @Deprecated
    public SSLContext createSSLContext(ClientAuth var1) throws ProcessException;

    public String getTrustStoreFile();

    public String getTrustStoreType();

    public String getTrustStorePassword();

    public boolean isTrustStoreConfigured();

    public String getKeyStoreFile();

    public String getKeyStoreType();

    public String getKeyStorePassword();

    public String getKeyPassword();

    public boolean isKeyStoreConfigured();

    public String getSslAlgorithm();

    public static AllowableValue[] buildAlgorithmAllowableValues() {
        HashSet<String> supportedProtocols = new HashSet<String>();
        supportedProtocols.add("TLS");
        supportedProtocols.add("SSL");
        try {
            supportedProtocols.addAll(Arrays.asList(SSLContext.getDefault().createSSLEngine().getSupportedProtocols()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return SSLContextService.formAllowableValues(supportedProtocols);
    }

    public static AllowableValue[] formAllowableValues(Set<String> rawValues) {
        int numProtocols = rawValues.size();
        ArrayList<String> valueList = new ArrayList<String>(rawValues);
        Collections.sort(valueList);
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        for (String protocol : valueList) {
            allowableValues.add(new AllowableValue(protocol));
        }
        return allowableValues.toArray(new AllowableValue[numProtocols]);
    }

    @Deprecated
    public static enum ClientAuth {
        WANT,
        REQUIRED,
        NONE;

    }
}

