/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.ssl;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.exception.ProcessException;

@Tags(value={"ssl", "secure", "certificate", "keystore", "truststore", "jks", "p12", "pkcs12", "pkcs"})
@CapabilityDescription(value="Provides the ability to configure keystore and/or truststore properties once and reuse that configuration throughout the application")
public interface SSLContextService
extends ControllerService {
    public SSLContext createSSLContext(ClientAuth var1) throws ProcessException;

    public String getTrustStoreFile();

    public String getTrustStoreType();

    public String getTrustStorePassword();

    public boolean isTrustStoreConfigured();

    public String getKeyStoreFile();

    public String getKeyStoreType();

    public String getKeyStorePassword();

    public String getKeyPassword();

    public boolean isKeyStoreConfigured();

    public String getSslAlgorithm();

    public static AllowableValue[] buildAlgorithmAllowableValues() {
        HashSet<String> supportedProtocols = new HashSet<String>();
        supportedProtocols.add("TLS");
        supportedProtocols.add("SSL");
        try {
            supportedProtocols.addAll(Arrays.asList(SSLContext.getDefault().createSSLEngine().getSupportedProtocols()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        int numProtocols = supportedProtocols.size();
        ArrayList supportedProtocolList = new ArrayList(supportedProtocols);
        Collections.sort(supportedProtocolList);
        ArrayList<AllowableValue> protocolAllowableValues = new ArrayList<AllowableValue>();
        for (String protocol : supportedProtocolList) {
            protocolAllowableValues.add(new AllowableValue(protocol));
        }
        return protocolAllowableValues.toArray(new AllowableValue[numProtocols]);
    }

    public static enum ClientAuth {
        WANT,
        REQUIRED,
        NONE;

    }
}

