/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.processorstatus;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;

public class ProcessorStatusEnumerator
implements Enumerator<Object> {
    private final ReportingContext context;
    private final ComponentLog logger;
    private final int[] fields;
    private Deque<Iterator<ProcessGroupStatus>> iteratorBreadcrumb;
    private Iterator<ProcessorStatus> processorStatusIterator;
    private Object currentRow;
    private int recordsRead = 0;

    public ProcessorStatusEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.context = context;
        this.logger = logger;
        this.fields = fields;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        ProcessorStatus connectionStatus;
        this.currentRow = null;
        if (this.iteratorBreadcrumb.isEmpty()) {
            ProcessGroupStatus rootStatus = this.context.getEventAccess().getControllerStatus();
            this.iteratorBreadcrumb.push(rootStatus.getProcessGroupStatus().iterator());
            this.processorStatusIterator = rootStatus.getProcessorStatus().iterator();
        }
        if ((connectionStatus = this.getNextProcessorStatus()) == null) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        this.currentRow = this.filterColumns(connectionStatus);
        ++this.recordsRead;
        return true;
    }

    protected int getRecordsRead() {
        return this.recordsRead;
    }

    protected void onFinish() {
    }

    private Object filterColumns(ProcessorStatus status) {
        if (status == null) {
            return null;
        }
        Object[] row = new Object[]{status.getId(), status.getGroupId(), status.getName(), status.getType(), status.getAverageLineageDuration(TimeUnit.MILLISECONDS), status.getBytesRead(), status.getBytesWritten(), status.getBytesReceived(), status.getBytesSent(), status.getFlowFilesRemoved(), status.getFlowFilesReceived(), status.getFlowFilesSent(), status.getInputCount(), status.getInputBytes(), status.getOutputCount(), status.getOutputBytes(), status.getActiveThreadCount(), status.getTerminatedThreadCount(), status.getInvocations(), status.getProcessingNanos(), status.getRunStatus().name(), status.getExecutionNode() == null ? null : status.getExecutionNode().name()};
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        this.processorStatusIterator = null;
        this.iteratorBreadcrumb = new LinkedList<Iterator<ProcessGroupStatus>>();
    }

    public void close() {
    }

    private ProcessorStatus getNextProcessorStatus() {
        if (this.processorStatusIterator != null && this.processorStatusIterator.hasNext()) {
            return this.processorStatusIterator.next();
        }
        this.processorStatusIterator = null;
        Iterator<ProcessGroupStatus> i = this.iteratorBreadcrumb.peek();
        if (i == null) {
            return null;
        }
        if (i.hasNext()) {
            ProcessGroupStatus nextPG = i.next();
            this.iteratorBreadcrumb.push(nextPG.getProcessGroupStatus().iterator());
            this.processorStatusIterator = nextPG.getProcessorStatus().iterator();
            return this.getNextProcessorStatus();
        }
        this.iteratorBreadcrumb.pop();
        return this.getNextProcessorStatus();
    }
}

