/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.processgroupstatus;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.util.Tuple;

public class ProcessGroupStatusEnumerator
implements Enumerator<Object> {
    private final ReportingContext context;
    private final ComponentLog logger;
    private final int[] fields;
    private Deque<Tuple<Iterator<ProcessGroupStatus>, String>> iteratorBreadcrumb;
    private Object currentRow;
    private int recordsRead = 0;

    public ProcessGroupStatusEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.context = context;
        this.logger = logger;
        this.fields = fields;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        Tuple processGroupStatus;
        this.currentRow = null;
        if (this.iteratorBreadcrumb.isEmpty()) {
            ProcessGroupStatus rootStatus = this.context.getEventAccess().getControllerStatus();
            this.iteratorBreadcrumb.push((Tuple<Iterator<ProcessGroupStatus>, String>)new Tuple(rootStatus.getProcessGroupStatus().iterator(), (Object)rootStatus.getId()));
            processGroupStatus = new Tuple((Object)rootStatus, null);
        } else {
            processGroupStatus = this.getNextProcessGroupStatus();
        }
        if (processGroupStatus == null) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        this.currentRow = this.filterColumns((ProcessGroupStatus)processGroupStatus.getKey(), (String)processGroupStatus.getValue());
        ++this.recordsRead;
        return true;
    }

    protected int getRecordsRead() {
        return this.recordsRead;
    }

    protected void onFinish() {
    }

    private Object filterColumns(ProcessGroupStatus status, String parentId) {
        if (status == null) {
            return null;
        }
        Object[] row = new Object[]{status.getId(), parentId, status.getName(), status.getBytesRead(), status.getBytesWritten(), status.getBytesReceived(), status.getBytesSent(), status.getBytesTransferred(), status.getFlowFilesReceived(), status.getFlowFilesSent(), status.getFlowFilesTransferred(), status.getInputContentSize(), status.getInputCount(), status.getOutputContentSize(), status.getOutputCount(), status.getQueuedContentSize(), status.getActiveThreadCount(), status.getTerminatedThreadCount(), status.getQueuedCount(), status.getVersionedFlowState() == null ? null : status.getVersionedFlowState().name(), status.getProcessingNanos()};
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        this.iteratorBreadcrumb = new LinkedList<Tuple<Iterator<ProcessGroupStatus>, String>>();
    }

    public void close() {
    }

    private Tuple<ProcessGroupStatus, String> getNextProcessGroupStatus() {
        Tuple<Iterator<ProcessGroupStatus>, String> top = this.iteratorBreadcrumb.peek();
        if (top == null) {
            return null;
        }
        Iterator i = (Iterator)top.getKey();
        String parentId = (String)top.getValue();
        if (i.hasNext()) {
            ProcessGroupStatus nextPG = (ProcessGroupStatus)i.next();
            this.iteratorBreadcrumb.push((Tuple<Iterator<ProcessGroupStatus>, String>)new Tuple(nextPG.getProcessGroupStatus().iterator(), (Object)nextPG.getId()));
            return new Tuple((Object)nextPG, (Object)parentId);
        }
        Tuple<Iterator<ProcessGroupStatus>, String> pop = this.iteratorBreadcrumb.pop();
        return this.getNextProcessGroupStatus();
    }
}

