/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.metrics;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.metrics.JvmMetricsEnumerator;
import org.apache.nifi.reporting.sql.metrics.JvmMetricsTableScan;
import org.apache.nifi.reporting.util.metrics.MetricsService;

public class JvmMetricsTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ComponentLog logger;
    private RelDataType relDataType = null;
    private volatile ReportingContext context;
    private volatile int maxRecordsRead;
    private volatile MetricsService metricsService = new MetricsService();
    private volatile JvmMetrics virtualMachineMetrics;
    private final Set<JvmMetricsEnumerator> enumerators = new HashSet<JvmMetricsEnumerator>();

    public JvmMetricsTable(ReportingContext context, ComponentLog logger) {
        this.context = context;
        this.logger = logger;
        this.virtualMachineMetrics = JmxJvmMetrics.getInstance();
    }

    public String toString() {
        return "JvmMetricsTable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<JvmMetricsEnumerator> set = this.enumerators;
        synchronized (set) {
            for (JvmMetricsEnumerator enumerator : this.enumerators) {
                enumerator.close();
            }
        }
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Enumerator<Object> enumerator() {
                JvmMetricsEnumerator jvmMetricsEnumerator = new JvmMetricsEnumerator(JvmMetricsTable.this.context, JvmMetricsTable.this.logger, fields){

                    @Override
                    protected void onFinish() {
                        int recordCount = this.getRecordsRead();
                        if (recordCount > JvmMetricsTable.this.maxRecordsRead) {
                            JvmMetricsTable.this.maxRecordsRead = recordCount;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Set set = JvmMetricsTable.this.enumerators;
                        synchronized (set) {
                            JvmMetricsTable.this.enumerators.remove(this);
                        }
                        super.close();
                    }
                };
                Set set = JvmMetricsTable.this.enumerators;
                synchronized (set) {
                    JvmMetricsTable.this.enumerators.add(jvmMetricsEnumerator);
                }
                return jvmMetricsEnumerator;
            }
        };
    }

    public int getRecordsRead() {
        return this.maxRecordsRead;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = i;
        }
        return new JvmMetricsTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.relDataType != null) {
            return this.relDataType;
        }
        List names = Stream.of("jvm.daemon_thread_count", "jvm.thread_count", "jvm.thread_states.blocked", "jvm.thread_states.runnable", "jvm.thread_states.terminated", "jvm.thread_states.timed_waiting", "jvm.uptime", "jvm.heap_used", "jvm.heap_usage", "jvm.non_heap_usage", "jvm.file_descriptor_usage").map(name -> name.replace(".", "_").replace("-", "_")).collect(Collectors.toList());
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        types.add(typeFactory.createJavaType(Integer.TYPE));
        types.add(typeFactory.createJavaType(Integer.TYPE));
        types.add(typeFactory.createJavaType(Integer.TYPE));
        types.add(typeFactory.createJavaType(Integer.TYPE));
        types.add(typeFactory.createJavaType(Integer.TYPE));
        types.add(typeFactory.createJavaType(Integer.TYPE));
        types.add(typeFactory.createJavaType(Long.TYPE));
        types.add(typeFactory.createJavaType(Double.TYPE));
        types.add(typeFactory.createJavaType(Double.TYPE));
        types.add(typeFactory.createJavaType(Double.TYPE));
        types.add(typeFactory.createJavaType(Double.TYPE));
        this.metricsService.getMetrics(this.virtualMachineMetrics);
        for (Map.Entry entry : this.virtualMachineMetrics.garbageCollectors().entrySet()) {
            String gcName = ((String)entry.getKey()).replace(" ", "").replace("-", "_");
            names.add(("jvm.gc.runs_" + gcName).replace(".", "_"));
            names.add(("jvm.gc.time_" + gcName).replace(".", "_"));
            types.add(typeFactory.createJavaType(Long.TYPE));
            types.add(typeFactory.createJavaType(Long.TYPE));
        }
        this.relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return this.relDataType;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TEMPORARY_TABLE;
    }
}

