/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.flowconfighistory;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Pair;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.flowconfighistory.FlowConfigHistoryEnumerator;
import org.apache.nifi.reporting.sql.flowconfighistory.FlowConfigHistoryTableScan;

public class FlowConfigHistoryTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ComponentLog logger;
    private RelDataType relDataType = null;
    private final ReportingContext context;
    private volatile int maxRecordsRead;
    private final Set<FlowConfigHistoryEnumerator> enumerators = new HashSet<FlowConfigHistoryEnumerator>();

    public FlowConfigHistoryTable(ReportingContext context, ComponentLog logger) {
        this.context = context;
        this.logger = logger;
    }

    public String toString() {
        return "FlowConfigHistoryTable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<FlowConfigHistoryEnumerator> set = this.enumerators;
        synchronized (set) {
            for (FlowConfigHistoryEnumerator enumerator : this.enumerators) {
                enumerator.close();
            }
        }
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Enumerator<Object> enumerator() {
                FlowConfigHistoryEnumerator flowConfigHistoryEnumerator = new FlowConfigHistoryEnumerator(FlowConfigHistoryTable.this.context, FlowConfigHistoryTable.this.logger, fields){

                    @Override
                    protected void onFinish() {
                        int recordCount = this.getRecordsRead();
                        if (recordCount > FlowConfigHistoryTable.this.maxRecordsRead) {
                            FlowConfigHistoryTable.this.maxRecordsRead = recordCount;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void close() {
                        Set set = FlowConfigHistoryTable.this.enumerators;
                        synchronized (set) {
                            FlowConfigHistoryTable.this.enumerators.remove(this);
                        }
                        super.close();
                    }
                };
                Set set = FlowConfigHistoryTable.this.enumerators;
                synchronized (set) {
                    FlowConfigHistoryTable.this.enumerators.add(flowConfigHistoryEnumerator);
                }
                return flowConfigHistoryEnumerator;
            }
        };
    }

    public int getRecordsRead() {
        return this.maxRecordsRead;
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = i;
        }
        return new FlowConfigHistoryTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.relDataType != null) {
            return this.relDataType;
        }
        List<String> names = Arrays.asList("actionId", "actionTimestamp", "actionUserIdentity", "actionSourceId", "actionSourceName", "actionSourceType", "actionOperation", "configureDetailsName", "configureDetailsPreviousValue", "configureDetailsValue", "connectionSourceId", "connectionSourceName", "connectionSourceType", "connectionDestinationId", "connectionDestinationName", "connectionDestinationType", "connectionRelationship", "moveGroup", "moveGroupId", "movePreviousGroup", "movePreviousGroupId", "purgeEndDate");
        List<RelDataType> types = Arrays.asList(typeFactory.createJavaType(Integer.TYPE), typeFactory.createJavaType(Long.TYPE), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(String.class), typeFactory.createJavaType(Long.TYPE));
        this.relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return this.relDataType;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TEMPORARY_TABLE;
    }
}

