/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql.connectionstatuspredictions;

import org.apache.calcite.linq4j.Enumerator;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.analytics.ConnectionStatusPredictions;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.sql.util.ConnectionStatusRecursiveIterator;

public class ConnectionStatusPredictionsEnumerator
implements Enumerator<Object> {
    private final ReportingContext context;
    private final ComponentLog logger;
    private final int[] fields;
    private ConnectionStatusRecursiveIterator connectionStatusIterator;
    private Object currentRow;
    private int recordsRead = 0;

    public ConnectionStatusPredictionsEnumerator(ReportingContext context, ComponentLog logger, int[] fields) {
        this.context = context;
        this.connectionStatusIterator = new ConnectionStatusRecursiveIterator(context);
        this.logger = logger;
        this.fields = fields;
        this.reset();
    }

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        this.currentRow = null;
        ConnectionStatus connectionStatus = this.connectionStatusIterator.next();
        if (connectionStatus == null) {
            this.close();
            try {
                this.onFinish();
            }
            catch (Exception e) {
                this.logger.error("Failed to perform tasks when enumerator was finished", (Throwable)e);
            }
            return false;
        }
        this.currentRow = this.filterColumns(connectionStatus);
        ++this.recordsRead;
        return true;
    }

    protected int getRecordsRead() {
        return this.recordsRead;
    }

    protected void onFinish() {
    }

    private Object filterColumns(ConnectionStatus status) {
        if (status == null || status.getPredictions() == null) {
            return null;
        }
        ConnectionStatusPredictions predictions = status.getPredictions();
        if (predictions == null) {
            return null;
        }
        Object[] row = new Object[]{status.getId(), predictions.getNextPredictedQueuedBytes(), predictions.getNextPredictedQueuedCount(), predictions.getPredictedPercentBytes(), predictions.getPredictedPercentCount(), predictions.getPredictedTimeToBytesBackpressureMillis(), predictions.getPredictedTimeToCountBackpressureMillis(), predictions.getPredictionIntervalMillis()};
        if (this.fields == null) {
            return row;
        }
        if (this.fields.length == 1) {
            int desiredCellIndex = this.fields[0];
            return row[desiredCellIndex];
        }
        Object[] filtered = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int indexToKeep = this.fields[i];
            filtered[i] = row[indexToKeep];
        }
        return filtered;
    }

    public void reset() {
        this.connectionStatusIterator = null;
        this.connectionStatusIterator = new ConnectionStatusRecursiveIterator(this.context);
    }

    public void close() {
    }
}

