/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.sql.MetricsQueryService;
import org.apache.nifi.reporting.sql.MetricsSqlQueryService;
import org.apache.nifi.reporting.sql.QueryResult;
import org.apache.nifi.reporting.sql.QueryTimeAware;
import org.apache.nifi.reporting.sql.util.QueryMetricsUtil;
import org.apache.nifi.reporting.sql.util.TrackedQueryTime;
import org.apache.nifi.rules.PropertyContextActionHandler;
import org.apache.nifi.rules.engine.RulesEngineService;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.ResultSetRecordSet;
import org.apache.nifi.util.db.JdbcProperties;

@Tags(value={"reporting", "rules", "action", "action handler", "status", "connection", "processor", "jvm", "metrics", "history", "bulletin", "sql"})
@CapabilityDescription(value="Triggers rules-driven actions based on metrics values ")
@Stateful(scopes={Scope.LOCAL}, description="Stores the Reporting Task's last execution time so that on restart the task knows where it left off.")
public class MetricsEventReportingTask
extends AbstractReportingTask
implements QueryTimeAware {
    private List<PropertyDescriptor> properties;
    private MetricsQueryService metricsQueryService;
    private volatile RulesEngineService rulesEngineService;
    private volatile PropertyContextActionHandler actionHandler;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected void init(ReportingInitializationContext config) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(QueryMetricsUtil.QUERY);
        properties.add(QueryMetricsUtil.RULES_ENGINE);
        properties.add(QueryMetricsUtil.ACTION_HANDLER);
        properties.add(JdbcProperties.VARIABLE_REGISTRY_ONLY_DEFAULT_PRECISION);
        properties.add(JdbcProperties.VARIABLE_REGISTRY_ONLY_DEFAULT_SCALE);
        this.properties = Collections.unmodifiableList(properties);
    }

    @OnScheduled
    public void setup(ConfigurationContext context) {
        this.actionHandler = (PropertyContextActionHandler)context.getProperty(QueryMetricsUtil.ACTION_HANDLER).asControllerService(PropertyContextActionHandler.class);
        this.rulesEngineService = (RulesEngineService)context.getProperty(QueryMetricsUtil.RULES_ENGINE).asControllerService(RulesEngineService.class);
        Integer defaultPrecision = context.getProperty(JdbcProperties.VARIABLE_REGISTRY_ONLY_DEFAULT_PRECISION).evaluateAttributeExpressions().asInteger();
        Integer defaultScale = context.getProperty(JdbcProperties.VARIABLE_REGISTRY_ONLY_DEFAULT_SCALE).evaluateAttributeExpressions().asInteger();
        this.metricsQueryService = new MetricsSqlQueryService(this.getLogger(), defaultPrecision, defaultScale);
    }

    public void onTrigger(ReportingContext context) {
        String sql = context.getProperty(QueryMetricsUtil.QUERY).evaluateAttributeExpressions().getValue();
        try {
            sql = this.processStartAndEndTimes(context, sql, TrackedQueryTime.BULLETIN_START_TIME, TrackedQueryTime.BULLETIN_END_TIME);
            sql = this.processStartAndEndTimes(context, sql, TrackedQueryTime.PROVENANCE_START_TIME, TrackedQueryTime.PROVENANCE_END_TIME);
            this.fireRules(context, this.actionHandler, this.rulesEngineService, sql);
        }
        catch (Exception e) {
            this.getLogger().error("Error opening loading rules: {}", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRules(ReportingContext context, PropertyContextActionHandler actionHandler, RulesEngineService engine, String query) throws Exception {
        this.getLogger().debug("Executing query: {}", new Object[]{query});
        QueryResult queryResult = this.metricsQueryService.query(context, query);
        ResultSetRecordSet recordSet = this.metricsQueryService.getResultSetRecordSet(queryResult);
        try {
            Record record;
            while ((record = recordSet.next()) != null) {
                HashMap<String, Object> facts = new HashMap<String, Object>();
                for (String fieldName : record.getRawFieldNames()) {
                    facts.put(fieldName, record.getValue(fieldName));
                }
                List actions = engine.fireRules(facts);
                if (actions == null || actions.isEmpty()) {
                    this.getLogger().debug("No actions required for provided facts.");
                    continue;
                }
                actions.forEach(action -> actionHandler.execute((PropertyContext)context, action, facts));
            }
        }
        catch (Throwable throwable) {
            this.metricsQueryService.closeQuietly(new AutoCloseable[]{recordSet});
            throw throwable;
        }
        this.metricsQueryService.closeQuietly(new AutoCloseable[]{recordSet});
    }
}

