/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.shopify.util;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;

public class IncrementalTimers {
    static final Duration EXCLUSIVE_TIME_WINDOW_ADJUSTMENT = Duration.ofMillis(1L);
    static final String LAST_EXECUTION_TIME_KEY = "last_execution_time";
    private final String startTime;
    private final String endTime;
    private final String exclusiveEndTime;

    private IncrementalTimers(String startTime, String endTime, String exclusiveEndTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.exclusiveEndTime = exclusiveEndTime;
    }

    public static IncrementalTimers ofState(Map<String, String> stateMap, String initialStartTime, Long incrDelayMs, Instant currentExecutionTime) {
        String startTime = stateMap.get(LAST_EXECUTION_TIME_KEY);
        if (startTime == null && initialStartTime != null) {
            startTime = initialStartTime;
        }
        if (incrDelayMs != null) {
            currentExecutionTime = currentExecutionTime.minus(incrDelayMs, ChronoUnit.MILLIS);
        }
        currentExecutionTime = currentExecutionTime.truncatedTo(ChronoUnit.SECONDS);
        String endTime = currentExecutionTime.toString();
        String exclusiveEndTime = currentExecutionTime.minus(EXCLUSIVE_TIME_WINDOW_ADJUSTMENT).toString();
        return new IncrementalTimers(startTime, endTime, exclusiveEndTime);
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getExclusiveEndTime() {
        return this.exclusiveEndTime;
    }
}

