/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.shopify.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.shopify.model.IncrementalLoadingParameter;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public class ShopifyRestService {
    private static final String HTTPS = "https";
    static final String ACCESS_TOKEN_KEY = "X-Shopify-Access-Token";
    private final WebClientServiceProvider webClientServiceProvider;
    private final String version;
    private final String baseUrl;
    private final String accessToken;
    private final String resourceName;
    private final String limit;
    private final IncrementalLoadingParameter incrementalLoadingParameter;

    public ShopifyRestService(WebClientServiceProvider webClientServiceProvider, String version, String baseUrl, String accessToken, String resourceName, String limit, IncrementalLoadingParameter incrementalLoadingParameter) {
        this.webClientServiceProvider = webClientServiceProvider;
        this.version = version;
        this.baseUrl = baseUrl;
        this.accessToken = accessToken;
        this.resourceName = resourceName;
        this.limit = limit;
        this.incrementalLoadingParameter = incrementalLoadingParameter;
    }

    public HttpResponseEntity getShopifyObjects() {
        URI uri = this.getUri();
        return this.retrieveResponse(uri);
    }

    public HttpResponseEntity getShopifyObjects(String startTime, String endTime) {
        URI uri = this.getIncrementalUri(startTime, endTime);
        return this.retrieveResponse(uri);
    }

    public HttpResponseEntity getShopifyObjects(String cursor) {
        URI uri;
        try {
            uri = new URI(cursor);
        }
        catch (URISyntaxException e) {
            throw new ProcessException("Could not create URI from cursor while paging", (Throwable)e);
        }
        return this.retrieveResponse(uri);
    }

    public String getBaseUriString() {
        return this.getBaseUri().build().toString();
    }

    private HttpResponseEntity retrieveResponse(URI uri) {
        return this.webClientServiceProvider.getWebClientService().get().uri(uri).header(ACCESS_TOKEN_KEY, this.accessToken).retrieve();
    }

    protected HttpUriBuilder getBaseUri() {
        return this.webClientServiceProvider.getHttpUriBuilder().scheme(HTTPS).host(this.baseUrl).addPathSegment("admin").addPathSegment("api").addPathSegment(this.version).addPathSegment(this.resourceName + ".json");
    }

    URI getUri() {
        HttpUriBuilder uriBuilder = this.getBaseUri();
        if (this.limit != null) {
            uriBuilder.addQueryParameter("limit", this.limit);
        }
        return uriBuilder.build();
    }

    URI getIncrementalUri(String startTime, String endTime) {
        HttpUriBuilder uriBuilder = this.getBaseUri();
        if (this.limit != null) {
            uriBuilder.addQueryParameter("limit", this.limit);
        }
        if (this.incrementalLoadingParameter != IncrementalLoadingParameter.NONE) {
            if (startTime != null) {
                String minTime = this.incrementalLoadingParameter.name().toLowerCase(Locale.ROOT) + "_min";
                uriBuilder.addQueryParameter(minTime, startTime);
            }
            String maxTime = this.incrementalLoadingParameter.name().toLowerCase(Locale.ROOT) + "_max";
            uriBuilder.addQueryParameter(maxTime, endTime);
        }
        return uriBuilder.build();
    }
}

