/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.shopify.model;

import java.util.List;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.processors.shopify.model.ResourceDirectory;
import org.apache.nifi.processors.shopify.model.ShopifyResource;

public enum ResourceType implements DescribedValue
{
    CUSTOMERS("Customers", "Query a Customer resource", "Customer Category", "Customer resource to query", ResourceDirectory.CUSTOMER_RESOURCES),
    DISCOUNTS("Discounts", "Query a Discount resource", "Discount Category", "Discount resource to query", ResourceDirectory.DISCOUNT_RESOURCES),
    INVENTORY("Inventory", "Query an Inventory resource", "Inventory Category", "Inventory resource to query", ResourceDirectory.INVENTORY_RESOURCES),
    ONLINE_STORE("Online Store", "Query an Online Store resource", "Online Store Category", "Online Store resource to query", ResourceDirectory.ONLINE_STORE_RESOURCES),
    ORDERS("Orders", "Query an Order resource", "Order Category", "Order resource to query", ResourceDirectory.ORDER_RESOURCES),
    PRODUCT("Products", "Query a Product resource", "Product Category", "Product resource to query", ResourceDirectory.PRODUCT_RESOURCES),
    SALES_CHANNELS("Sales Channels", "Query a Sales Channel resource", "Sales Channel Category", "Sales Channel resource to query", ResourceDirectory.SALES_CHANNEL_RESOURCES),
    STORE_PROPERTIES("Store Properties", "Query a Store Property resource", "Store Property Category", "Store Property resource to query", ResourceDirectory.STORE_PROPERTY_RESOURCES);

    private final String allowableValueDisplayName;
    private final String allowableValueDescription;
    private final String propertyDisplayName;
    private final String propertyDescription;
    private final List<ShopifyResource> resources;

    private ResourceType(String allowableValueDisplayName, String allowableValueDescription, String propertyDisplayName, String propertyDescription, List<ShopifyResource> resources) {
        this.allowableValueDisplayName = allowableValueDisplayName;
        this.allowableValueDescription = allowableValueDescription;
        this.propertyDisplayName = propertyDisplayName;
        this.propertyDescription = propertyDescription;
        this.resources = resources;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.allowableValueDisplayName;
    }

    public String getDescription() {
        return this.allowableValueDescription;
    }

    public String getPropertyDescription() {
        return this.propertyDescription;
    }

    public String getPropertyDisplayName() {
        return this.propertyDisplayName;
    }

    public List<ShopifyResource> getResources() {
        return this.resources;
    }

    public ShopifyResource getResource(String value) {
        return this.getResources().stream().filter(s -> s.getValue().equals(value)).findFirst().get();
    }

    public AllowableValue[] getResourcesAsAllowableValues() {
        return (AllowableValue[])this.getResources().stream().map(ShopifyResource::getAllowableValue).toArray(AllowableValue[]::new);
    }
}

