/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup.script;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;
import org.apache.nifi.script.AbstractScriptedControllerService;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;

@Tags(value={"lookup", "record", "script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Allows the user to provide a scripted LookupService instance in order to enrich records from an incoming flow file. Please note, that due to a bug in Jython that remains unresolved, it is not possible to use Jython to write a script for this service in Python.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class ScriptedLookupService
extends AbstractScriptedControllerService
implements LookupService<Object> {
    protected final AtomicReference<LookupService<Object>> lookupService = new AtomicReference();
    private volatile String kerberosServicePrincipal = null;
    private volatile File kerberosConfigFile = null;
    private volatile File kerberosServiceKeytab = null;

    public Optional<Object> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        return this.lookupService.get().lookup(coordinates);
    }

    public Set<String> getRequiredKeys() {
        return this.lookupService.get().getRequiredKeys();
    }

    public Class<?> getValueType() {
        return this.lookupService.get().getValueType();
    }

    protected void init(ControllerServiceInitializationContext context) {
        this.kerberosServicePrincipal = context.getKerberosServicePrincipal();
        this.kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosServiceKeytab = context.getKerberosServiceKeytab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<Object> supportedPropertyDescriptors;
        block8: {
            AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
            synchronized (atomicBoolean) {
                if (!this.scriptingComponentHelper.isInitialized.get()) {
                    this.scriptingComponentHelper.createResources();
                }
            }
            supportedPropertyDescriptors = new ArrayList<Object>();
            ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
            _temp.addAll(this.scriptingComponentHelper.getDescriptors());
            _temp.remove(this.scriptingComponentHelper.SCRIPT_ENGINE);
            PropertyDescriptor.Builder jythonLessEngineProp = new PropertyDescriptor.Builder().fromPropertyDescriptor(this.scriptingComponentHelper.SCRIPT_ENGINE);
            List<AllowableValue> filtered = this.scriptingComponentHelper.getScriptEngineAllowableValues().stream().filter(allowableValue -> !allowableValue.getValue().contains("ython")).collect(Collectors.toList());
            jythonLessEngineProp.allowableValues(filtered.toArray(new AllowableValue[filtered.size()]));
            supportedPropertyDescriptors.add(jythonLessEngineProp.build());
            supportedPropertyDescriptors.addAll(_temp);
            ConfigurableComponent instance = (ConfigurableComponent)this.lookupService.get();
            if (instance != null) {
                try {
                    List instanceDescriptors = instance.getPropertyDescriptors();
                    if (instanceDescriptors != null) {
                        supportedPropertyDescriptors.addAll(instanceDescriptors);
                    }
                }
                catch (Throwable t) {
                    ComponentLog logger = this.getLogger();
                    String message = "Unable to get property descriptors from Processor: " + t;
                    logger.error(message);
                    if (!logger.isDebugEnabled()) break block8;
                    logger.error(message, t);
                }
            }
        }
        return Collections.unmodifiableList(supportedPropertyDescriptors);
    }

    @Override
    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    @Override
    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        ComponentLog logger = this.getLogger();
        ConfigurableComponent instance = (ConfigurableComponent)this.lookupService.get();
        if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor) || ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor) || ScriptingComponentUtils.MODULES.equals((Object)descriptor) || this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
            this.scriptNeedsReload.set(true);
            if (this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
                this.scriptEngine = null;
            }
        } else if (instance != null) {
            try {
                instance.onPropertyModified(descriptor, oldValue, newValue);
            }
            catch (Exception e) {
                String message = "Unable to invoke onPropertyModified from scripted LookupService: " + e;
                logger.error(message, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        block11: {
            AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
            synchronized (atomicBoolean) {
                if (!this.scriptingComponentHelper.isInitialized.get()) {
                    this.scriptingComponentHelper.createResources();
                }
            }
            super.onEnabled(context);
            Invocable invocable = (Invocable)((Object)this.scriptEngine);
            if (this.configurationContext != null) {
                try {
                    Object obj = this.scriptEngine.get("lookupService");
                    if (obj != null) {
                        try {
                            invocable.invokeMethod(obj, "onEnabled", context);
                        }
                        catch (NoSuchMethodException nsme) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Configured script LookupService does not contain an onEnabled() method.");
                            }
                            break block11;
                        }
                    }
                    throw new ScriptException("No LookupService was defined by the script.");
                }
                catch (ScriptException se) {
                    throw new ProcessException("Error executing onEnabled(context) method", (Throwable)se);
                }
            }
        }
    }

    @OnDisabled
    public void onDisabled(ConfigurationContext context) {
        block7: {
            Invocable invocable = (Invocable)((Object)this.scriptEngine);
            if (this.configurationContext != null) {
                try {
                    Object obj = this.scriptEngine.get("lookupService");
                    if (obj != null) {
                        try {
                            invocable.invokeMethod(obj, "onDisabled", context);
                        }
                        catch (NoSuchMethodException nsme) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Configured script LookupService does not contain an onDisabled() method.");
                            }
                            break block7;
                        }
                    }
                    throw new ScriptException("No LookupService was defined by the script.");
                }
                catch (ScriptException se) {
                    throw new ProcessException("Error executing onDisabled(context) method", (Throwable)se);
                }
            }
        }
    }

    @Override
    public void setup() {
        if (this.scriptEngine == null) {
            this.scriptingComponentHelper.setup(1, this.getLogger());
            this.scriptEngine = (ScriptEngine)this.scriptingComponentHelper.engineQ.poll();
        }
        if (this.scriptEngine == null) {
            throw new ProcessException("No script engine available!");
        }
        if (this.scriptNeedsReload.get() || this.lookupService.get() == null) {
            if (ScriptingComponentHelper.isFile(this.scriptingComponentHelper.getScriptPath())) {
                this.reloadScriptFile(this.scriptingComponentHelper.getScriptPath());
            } else {
                this.reloadScriptBody(this.scriptingComponentHelper.getScriptBody());
            }
            this.scriptNeedsReload.set(false);
        }
    }

    @Override
    protected boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block11: {
            results = new HashSet<ValidationResult>();
            try {
                if (this.scriptEngine instanceof Invocable) {
                    Invocable invocable = (Invocable)((Object)this.scriptEngine);
                    ScriptEngineConfigurator configurator = this.scriptingComponentHelper.scriptEngineConfiguratorMap.get(this.scriptingComponentHelper.getScriptEngineName().toLowerCase());
                    if (configurator != null) {
                        configurator.eval(this.scriptEngine, scriptBody, this.scriptingComponentHelper.getModules());
                    } else {
                        this.scriptEngine.eval(scriptBody);
                    }
                    Object obj = this.scriptEngine.get("lookupService");
                    if (obj != null) {
                        ComponentLog logger;
                        block10: {
                            logger = this.getLogger();
                            try {
                                invocable.invokeMethod(obj, "setLogger", logger);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block10;
                                logger.debug("Scripted LookupService does not contain a setLogger method.");
                            }
                        }
                        LookupService scriptedLookupService = invocable.getInterface(obj, LookupService.class);
                        this.lookupService.set((LookupService<Object>)scriptedLookupService);
                        if (scriptedLookupService == null) break block11;
                        try {
                            scriptedLookupService.initialize(new ControllerServiceInitializationContext(){

                                public String getIdentifier() {
                                    return ScriptedLookupService.this.getIdentifier();
                                }

                                public ComponentLog getLogger() {
                                    return logger;
                                }

                                public StateManager getStateManager() {
                                    return ScriptedLookupService.this.getStateManager();
                                }

                                public ControllerServiceLookup getControllerServiceLookup() {
                                    return ScriptedLookupService.super.getControllerServiceLookup();
                                }

                                public String getKerberosServicePrincipal() {
                                    return ScriptedLookupService.this.kerberosServicePrincipal;
                                }

                                public File getKerberosServiceKeytab() {
                                    return ScriptedLookupService.this.kerberosServiceKeytab;
                                }

                                public File getKerberosConfigurationFile() {
                                    return ScriptedLookupService.this.kerberosConfigFile;
                                }
                            });
                            break block11;
                        }
                        catch (Exception e) {
                            logger.error("Unable to initialize scripted LookupService: " + e.getLocalizedMessage(), (Throwable)e);
                            throw new ProcessException((Throwable)e);
                        }
                    }
                    throw new ScriptException("No LookupService was defined by the script.");
                }
                throw new ScriptException("Script engine is not Invocable, cannot be used for ScriptedLookupService");
            }
            catch (Exception ex) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptedLookupServiceValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptingComponentHelper.getScriptPath()).build());
            }
        }
        this.validationResults.set(results);
        return results.isEmpty();
    }
}

