/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script.impl;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.processors.script.engine.ClojureScriptEngine;
import org.apache.nifi.script.impl.BaseScriptRunner;

public class ClojureScriptRunner
extends BaseScriptRunner {
    private static final String PRELOADS = "(:import \n[org.apache.nifi.components AbstractConfigurableComponent AllowableValue ConfigurableComponent PropertyDescriptor PropertyValue ValidationContext ValidationResult Validator]\n[org.apache.nifi.components.state Scope StateManager StateMap]\n[org.apache.nifi.flowfile FlowFile]\n[org.apache.nifi.processor AbstractProcessor AbstractSessionFactoryProcessor DataUnit FlowFileFilter ProcessContext Processor ProcessorInitializationContext ProcessSession ProcessSessionFactory Relationship ProcessContext]\n[org.apache.nifi.processor.exception FlowFileAccessException FlowFileHandlingException MissingFlowFileException ProcessException]\n[org.apache.nifi.processor.io InputStreamCallback OutputStreamCallback StreamCallback]\n[org.apache.nifi.processor.util FlowFileFilters StandardValidators]\n[org.apache.nifi.processors.script ExecuteScript InvokeScriptedProcessor ScriptRunner]\n[org.apache.nifi.script ScriptingComponentHelper ScriptingComponentUtils]\n[org.apache.nifi.logging ComponentLog]\n[org.apache.nifi.lookup LookupService RecordLookupService StringLookupService LookupFailureException]\n[org.apache.nifi.record.sink RecordSinkService]\n)\n";

    public ClojureScriptRunner(ScriptEngine engine, String scriptBody, String[] modulePaths) {
        super(engine, scriptBody, ClojureScriptRunner.buildPreloads(engine), modulePaths);
    }

    private static String buildPreloads(ScriptEngine engine) {
        return "(ns " + ((ClojureScriptEngine)engine).getNamespace() + " " + PRELOADS + ")\n";
    }

    @Override
    public String getScriptEngineName() {
        return "Clojure";
    }

    @Override
    public void run(Bindings bindings) throws ScriptException {
        this.scriptEngine.setBindings(bindings, 100);
        this.scriptEngine.eval(this.scriptBody);
    }
}

