/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractSessionFactoryProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.script.ExecuteScript;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.script.ScriptingComponentHelper;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.script.impl.FilteredPropertiesValidationContextAdapter;

@Tags(value={"script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Experimental - Invokes a script engine for a Processor defined in the given script. The script must define a valid class that implements the Processor interface, and it must set a variable 'processor' to an instance of the class. Processor methods such as onTrigger() will be delegated to the scripted Processor instance. Also any Relationships or PropertyDescriptors defined by the scripted processor will be added to the configuration dialog. The scripted processor can implement public void setLogger(ComponentLog logger) to get access to the parent logger, as well as public void onScheduled(ProcessContext context) and public void onStopped(ProcessContext context) methods to be invoked when the parent InvokeScriptedProcessor is scheduled or stopped, respectively.  NOTE: The script will be loaded when the processor is populated with property values, see the Restrictions section for more security implications.  Experimental: Impact of sustained usage not yet verified.")
@SupportsSensitiveDynamicProperties
@DynamicProperty(name="Script Engine Binding property", value="Binding property value passed to Script Runner", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Updates a script engine property specified by the Dynamic Property's key with the value specified by the Dynamic Property's value")
@Stateful(scopes={Scope.LOCAL, Scope.CLUSTER}, description="Scripts can store and retrieve state using the State Management APIs. Consult the State Manager section of the Developer's Guide for more details.")
@SeeAlso(value={ExecuteScript.class})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class InvokeScriptedProcessor
extends AbstractSessionFactoryProcessor {
    private final AtomicReference<Processor> processor = new AtomicReference();
    private final AtomicReference<Collection<ValidationResult>> validationResults = new AtomicReference(new ArrayList());
    private final AtomicBoolean scriptNeedsReload = new AtomicBoolean(true);
    private volatile ScriptRunner scriptRunner = null;
    private volatile String kerberosServicePrincipal = null;
    private volatile File kerberosConfigFile = null;
    private volatile File kerberosServiceKeytab = null;
    volatile ScriptingComponentHelper scriptingComponentHelper = new ScriptingComponentHelper();

    public Set<Relationship> getRelationships() {
        HashSet relationships;
        block4: {
            relationships = new HashSet();
            Processor instance = this.processor.get();
            if (instance != null) {
                try {
                    Set rels = instance.getRelationships();
                    if (rels != null && !rels.isEmpty()) {
                        relationships.addAll(rels);
                    }
                }
                catch (Throwable t) {
                    ComponentLog logger = this.getLogger();
                    String message = "Unable to get relationships from scripted Processor: " + t;
                    logger.error(message);
                    if (!logger.isDebugEnabled()) break block4;
                    logger.error(message, t);
                }
            }
        }
        return Collections.unmodifiableSet(relationships);
    }

    protected void init(ProcessorInitializationContext context) {
        this.kerberosServicePrincipal = context.getKerberosServicePrincipal();
        this.kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosServiceKeytab = context.getKerberosServiceKeytab();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> supportedPropertyDescriptors;
        block8: {
            AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
            synchronized (atomicBoolean) {
                if (!this.scriptingComponentHelper.isInitialized.get()) {
                    this.scriptingComponentHelper.createResources();
                }
            }
            supportedPropertyDescriptors = new ArrayList<PropertyDescriptor>(this.scriptingComponentHelper.getDescriptors());
            Processor instance = this.processor.get();
            if (instance != null) {
                try {
                    List instanceDescriptors = instance.getPropertyDescriptors();
                    if (instanceDescriptors != null) {
                        supportedPropertyDescriptors.addAll(instanceDescriptors);
                    }
                }
                catch (Throwable t) {
                    ComponentLog logger = this.getLogger();
                    String message = "Unable to get property descriptors from Processor: " + t;
                    logger.error(message);
                    if (!logger.isDebugEnabled()) break block8;
                    logger.error(message, t);
                }
            }
        }
        return Collections.unmodifiableList(supportedPropertyDescriptors);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    @OnScheduled
    public void setup(ProcessContext context) {
        this.scriptingComponentHelper.setupVariables((PropertyContext)context);
        this.setup();
        this.invokeScriptedProcessorMethod("onScheduled", context);
    }

    @OnConfigurationRestored
    public void onConfigurationRestored(ProcessContext context) {
        this.scriptingComponentHelper.setupVariables((PropertyContext)context);
        this.setup();
    }

    public void setup() {
        if (this.scriptNeedsReload.get() || this.processor.get() == null) {
            if (ScriptingComponentHelper.isFile(this.scriptingComponentHelper.getScriptPath())) {
                this.scriptNeedsReload.set(!this.reloadScriptFile(this.scriptingComponentHelper.getScriptPath()));
            } else {
                this.scriptNeedsReload.set(!this.reloadScriptBody(this.scriptingComponentHelper.getScriptBody()));
            }
        }
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        this.validationResults.set(new HashSet());
        ComponentLog logger = this.getLogger();
        Processor instance = this.processor.get();
        if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor) || ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor) || ScriptingComponentUtils.MODULES.equals((Object)descriptor) || this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
            if (ScriptingComponentUtils.SCRIPT_FILE.equals((Object)descriptor)) {
                this.scriptingComponentHelper.setScriptPath(newValue);
            } else if (ScriptingComponentUtils.SCRIPT_BODY.equals((Object)descriptor)) {
                this.scriptingComponentHelper.setScriptBody(newValue);
            } else if (this.scriptingComponentHelper.SCRIPT_ENGINE.equals((Object)descriptor)) {
                this.scriptingComponentHelper.setScriptEngineName(newValue);
            }
            this.scriptNeedsReload.set(true);
            this.scriptRunner = null;
        } else if (instance != null) {
            try {
                instance.onPropertyModified(descriptor, oldValue, newValue);
            }
            catch (Exception e) {
                String message = "Unable to invoke onPropertyModified from script Processor: " + e;
                logger.error(message, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean reloadScriptFile(String scriptPath) {
        if (StringUtils.isEmpty((CharSequence)scriptPath)) {
            return false;
        }
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try (FileInputStream scriptStream = new FileInputStream(scriptPath);){
            boolean throwable3 = this.reloadScript(IOUtils.toString((InputStream)scriptStream, (Charset)Charset.defaultCharset()));
            return throwable3;
        }
        catch (Exception e) {
            ComponentLog logger = this.getLogger();
            String message = "Unable to load script: " + e;
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + e).input(scriptPath).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    private boolean reloadScriptBody(String scriptBody) {
        if (StringUtils.isEmpty((CharSequence)scriptBody)) {
            return false;
        }
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        try {
            return this.reloadScript(scriptBody);
        }
        catch (Exception e) {
            ComponentLog logger = this.getLogger();
            String message = "Unable to load script: " + e;
            logger.error(message, (Throwable)e);
            results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + e).input(this.scriptingComponentHelper.getScriptPath()).build());
            this.validationResults.set(results);
            return results.isEmpty();
        }
    }

    private boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block10: {
            if (StringUtils.isEmpty((CharSequence)scriptBody)) {
                return true;
            }
            results = new HashSet<ValidationResult>();
            try {
                if (this.scriptRunner == null) {
                    this.scriptingComponentHelper.setupScriptRunners(1, scriptBody, this.getLogger());
                    this.scriptRunner = (ScriptRunner)this.scriptingComponentHelper.scriptRunnerQ.poll();
                }
                if (this.scriptRunner == null) {
                    throw new ProcessException("No script runner available");
                }
                ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
                if (!(scriptEngine instanceof Invocable)) break block10;
                Invocable invocable = (Invocable)((Object)scriptEngine);
                this.scriptRunner.run(scriptEngine.getBindings(100));
                Object obj = scriptEngine.get("processor");
                if (obj != null) {
                    ComponentLog logger;
                    block11: {
                        logger = this.getLogger();
                        try {
                            invocable.invokeMethod(obj, "setLogger", logger);
                        }
                        catch (NoSuchMethodException nsme) {
                            if (!logger.isDebugEnabled()) break block11;
                            logger.debug("Configured script Processor does not contain a setLogger method.");
                        }
                    }
                    Processor scriptProcessor = invocable.getInterface(obj, Processor.class);
                    this.processor.set(scriptProcessor);
                    if (scriptProcessor == null) break block10;
                    try {
                        scriptProcessor.initialize(new ProcessorInitializationContext(){

                            public String getIdentifier() {
                                return InvokeScriptedProcessor.this.getIdentifier();
                            }

                            public ComponentLog getLogger() {
                                return logger;
                            }

                            public ControllerServiceLookup getControllerServiceLookup() {
                                return InvokeScriptedProcessor.super.getControllerServiceLookup();
                            }

                            public NodeTypeProvider getNodeTypeProvider() {
                                return InvokeScriptedProcessor.super.getNodeTypeProvider();
                            }

                            public String getKerberosServicePrincipal() {
                                return InvokeScriptedProcessor.this.kerberosServicePrincipal;
                            }

                            public File getKerberosServiceKeytab() {
                                return InvokeScriptedProcessor.this.kerberosServiceKeytab;
                            }

                            public File getKerberosConfigurationFile() {
                                return InvokeScriptedProcessor.this.kerberosConfigFile;
                            }
                        });
                        break block10;
                    }
                    catch (Exception e) {
                        logger.error("Unable to initialize scripted Processor: " + e.getLocalizedMessage(), (Throwable)e);
                        throw new ProcessException((Throwable)e);
                    }
                }
                throw new ScriptException("No processor was defined by the script.");
            }
            catch (Exception ex) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptingComponentHelper.getScriptPath()).build());
            }
        }
        this.validationResults.set(results);
        return !results.isEmpty();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        Collection commonValidationResults = super.customValidate(context);
        if (!commonValidationResults.isEmpty()) {
            return commonValidationResults;
        }
        if (!this.validationResults.get().isEmpty()) {
            return this.validationResults.get();
        }
        Collection<ValidationResult> scriptingComponentHelperResults = this.scriptingComponentHelper.customValidate(context);
        if (scriptingComponentHelperResults != null && !scriptingComponentHelperResults.isEmpty()) {
            this.validationResults.set(scriptingComponentHelperResults);
            return scriptingComponentHelperResults;
        }
        this.scriptingComponentHelper.setScriptEngineName(context.getProperty(this.scriptingComponentHelper.SCRIPT_ENGINE).getValue());
        this.scriptingComponentHelper.setScriptPath(context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).evaluateAttributeExpressions().getValue());
        this.scriptingComponentHelper.setScriptBody(context.getProperty(ScriptingComponentUtils.SCRIPT_BODY).getValue());
        ResourceReferences resourceReferences = context.getProperty(ScriptingComponentUtils.MODULES).evaluateAttributeExpressions().asResources();
        this.scriptingComponentHelper.setModules(resourceReferences);
        this.setup();
        Processor instance = this.processor.get();
        Collection<ValidationResult> currentValidationResults = this.validationResults.get();
        if (currentValidationResults.isEmpty() && instance != null) {
            try {
                HashSet<PropertyDescriptor> innerPropertyDescriptor = new HashSet<PropertyDescriptor>(this.scriptingComponentHelper.getDescriptors());
                FilteredPropertiesValidationContextAdapter innerValidationContext = new FilteredPropertiesValidationContextAdapter(context, innerPropertyDescriptor);
                Collection instanceResults = instance.validate((ValidationContext)innerValidationContext);
                if (instanceResults != null && instanceResults.size() > 0) {
                    return instanceResults;
                }
            }
            catch (Exception e) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to validate the script Processor: " + e;
                logger.error(message, (Throwable)e);
                HashSet<ValidationResult> results = new HashSet<ValidationResult>();
                results.add(new ValidationResult.Builder().subject("Validation").valid(false).explanation("An error occurred calling validate in the configured script Processor.").input(context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).getValue()).build());
                return results;
            }
        }
        return currentValidationResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        ComponentLog log = this.getLogger();
        Processor instance = this.processor.get();
        Collection<ValidationResult> results = this.validationResults.get();
        if (!results.isEmpty()) {
            log.error(String.format("Unable to run because the Processor is not valid: [%s]", StringUtils.join(results, (String)", ")));
            context.yield();
            return;
        }
        if (instance != null) {
            try {
                instance.onTrigger(context, sessionFactory);
            }
            catch (ProcessException e) {
                String message = String.format("An error occurred executing the configured Processor [%s]: %s", new Object[]{context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).getValue(), e});
                log.error(message);
                throw e;
            }
        } else {
            log.error("There is no processor defined by the script");
        }
    }

    @OnAdded
    public void added() {
        this.scriptingComponentHelper.createResources();
    }

    @OnStopped
    public void stop(ProcessContext context) {
        if (!this.scriptNeedsReload.get()) {
            this.invokeScriptedProcessorMethod("onStopped", context);
        }
        this.scriptingComponentHelper.stop();
        this.processor.set(null);
        this.scriptRunner = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeScriptedProcessorMethod(String methodName, Object ... params) {
        if (this.scriptRunner == null) throw new ProcessException("Error creating ScriptRunner");
        ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
        if (!(scriptEngine instanceof Invocable)) return;
        Invocable invocable = (Invocable)((Object)scriptEngine);
        Object obj = scriptEngine.get("processor");
        if (obj == null) return;
        ComponentLog logger = this.getLogger();
        try {
            invocable.invokeMethod(obj, methodName, params);
            return;
        }
        catch (NoSuchMethodException nsme) {
            if (!logger.isDebugEnabled()) return;
            logger.debug("Configured script Processor does not contain the method " + methodName);
            return;
        }
        catch (Exception e) {
            logger.error("Error while executing the scripted processor's method " + methodName, (Throwable)e);
            if (!(e instanceof ProcessException)) throw new ProcessException((Throwable)e);
            throw (ProcessException)((Object)e);
        }
    }
}

