/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.engine.script;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.script.ScriptRunner;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.engine.RulesEngineService;
import org.apache.nifi.script.AbstractScriptedControllerService;
import org.apache.nifi.script.ScriptingComponentHelper;

@Tags(value={"rules", "rules engine", "script", "invoke", "groovy", "python", "jython", "jruby", "ruby", "javascript", "js", "lua", "luaj"})
@CapabilityDescription(value="Allows the user to provide a scripted RulesEngineService for custom firing of rules depending on the supplied facts. The script must set a variable 'rulesEngine' to an implementation of RulesEngineService.")
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.EXECUTE_CODE, explanation="Provides operator the ability to execute arbitrary code assuming all permissions that NiFi has.")})
public class ScriptedRulesEngine
extends AbstractScriptedControllerService
implements RulesEngineService {
    protected final AtomicReference<RulesEngineService> rulesEngine = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        return Collections.unmodifiableList(this.scriptingComponentHelper.getDescriptors());
    }

    @Override
    public void setup() {
        if (this.scriptNeedsReload.get() || this.rulesEngine.get() == null) {
            if (ScriptingComponentHelper.isFile(this.scriptingComponentHelper.getScriptPath())) {
                this.scriptNeedsReload.set(this.reloadScriptFile(this.scriptingComponentHelper.getScriptPath()));
            } else {
                this.scriptNeedsReload.set(this.reloadScriptBody(this.scriptingComponentHelper.getScriptBody()));
            }
        }
    }

    @Override
    protected boolean reloadScript(String scriptBody) {
        HashSet<ValidationResult> results;
        block10: {
            results = new HashSet<ValidationResult>();
            try {
                if (this.scriptRunner == null) {
                    this.scriptingComponentHelper.setupScriptRunners(1, scriptBody, this.getLogger());
                    this.scriptRunner = (ScriptRunner)this.scriptingComponentHelper.scriptRunnerQ.poll();
                }
                if (this.scriptRunner == null) {
                    throw new ProcessException("No script runner available!");
                }
                ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
                if (!(scriptEngine instanceof Invocable)) break block10;
                Invocable invocable = (Invocable)((Object)scriptEngine);
                this.scriptRunner.run(scriptEngine.getBindings(100));
                Object obj = scriptEngine.get("rulesEngine");
                if (obj != null) {
                    block12: {
                        ComponentLog logger;
                        block11: {
                            logger = this.getLogger();
                            try {
                                invocable.invokeMethod(obj, "setLogger", logger);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block11;
                                logger.debug("Configured script RulesEngineService does not contain a setLogger method.");
                            }
                        }
                        if (this.configurationContext != null) {
                            try {
                                invocable.invokeMethod(obj, "setConfigurationContext", this.configurationContext);
                            }
                            catch (NoSuchMethodException nsme) {
                                if (!logger.isDebugEnabled()) break block12;
                                logger.debug("Configured script RulesEngineService does not contain a setConfigurationContext method.");
                            }
                        }
                    }
                    RulesEngineService scriptedReader = invocable.getInterface(obj, RulesEngineService.class);
                    this.rulesEngine.set(scriptedReader);
                    break block10;
                }
                throw new ScriptException("No RecordReader was defined by the script.");
            }
            catch (Exception ex) {
                ComponentLog logger = this.getLogger();
                String message = "Unable to load script: " + ex.getLocalizedMessage();
                logger.error(message, (Throwable)ex);
                results.add(new ValidationResult.Builder().subject("ScriptValidation").valid(false).explanation("Unable to load script due to " + ex.getLocalizedMessage()).input(this.scriptingComponentHelper.getScriptPath()).build());
            }
        }
        this.validationResults.set(results);
        return results.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        AtomicBoolean atomicBoolean = this.scriptingComponentHelper.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.scriptingComponentHelper.isInitialized.get()) {
                this.scriptingComponentHelper.createResources();
            }
        }
        super.onEnabled(context);
        if (this.scriptRunner == null) throw new ProcessException("Error creating ScriptRunner");
        ScriptEngine scriptEngine = this.scriptRunner.getScriptEngine();
        Invocable invocable = (Invocable)((Object)scriptEngine);
        if (this.configurationContext == null) return;
        try {
            Object obj = scriptEngine.get("rulesEngine");
            if (obj == null) throw new ScriptException("No RulesEngineService was defined by the script.");
            try {
                invocable.invokeMethod(obj, "onEnabled", context);
                return;
            }
            catch (NoSuchMethodException nsme) {
                if (!this.getLogger().isDebugEnabled()) return;
                this.getLogger().debug("Configured script RulesEngineService does not contain an onEnabled() method.");
            }
            return;
        }
        catch (ScriptException se) {
            throw new ProcessException("Error executing onEnabled(context) method: " + se.getMessage(), (Throwable)se);
        }
    }

    public List<Action> fireRules(Map<String, Object> facts) {
        if (this.rulesEngine.get() != null) {
            return this.rulesEngine.get().fireRules(facts);
        }
        return null;
    }
}

