/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;

public abstract class AbstractModuleClassloaderConfigurator
implements ScriptEngineConfigurator {
    @Override
    public URL[] getModuleURLsForClasspath(String[] modulePaths, ComponentLog log) {
        LinkedList<URL> additionalClasspath = new LinkedList<URL>();
        if (modulePaths != null) {
            for (String modulePathString : modulePaths) {
                File modulePath = new File(modulePathString);
                if (modulePath.exists()) {
                    File[] jarFiles;
                    try {
                        additionalClasspath.add(modulePath.toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        log.warn("{} is not a valid file/folder, ignoring", new Object[]{modulePath.getAbsolutePath()}, (Throwable)mue);
                    }
                    if (!modulePath.isDirectory() || (jarFiles = modulePath.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && name.endsWith(".jar");
                        }
                    })) == null) continue;
                    for (File jarFile : jarFiles) {
                        try {
                            additionalClasspath.add(jarFile.toURI().toURL());
                        }
                        catch (MalformedURLException mue) {
                            log.warn("{} is not a valid file/folder, ignoring", new Object[]{modulePath.getAbsolutePath()}, (Throwable)mue);
                        }
                    }
                    continue;
                }
                log.warn("{} does not exist, ignoring", new Object[]{modulePath.getAbsolutePath()});
            }
        }
        return additionalClasspath.toArray(new URL[additionalClasspath.size()]);
    }
}

