/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.script.ScriptEngineConfigurator;
import org.apache.nifi.script.ScriptingComponentUtils;
import org.apache.nifi.util.StringUtils;

public class ScriptingComponentHelper {
    public PropertyDescriptor SCRIPT_ENGINE;
    public final Map<String, ScriptEngineConfigurator> scriptEngineConfiguratorMap = new ConcurrentHashMap<String, ScriptEngineConfigurator>();
    public final AtomicBoolean isInitialized = new AtomicBoolean(false);
    public Map<String, ScriptEngineFactory> scriptEngineFactoryMap;
    private String scriptEngineName;
    private String scriptPath;
    private String scriptBody;
    private String[] modules;
    private List<PropertyDescriptor> descriptors;
    private List<AllowableValue> engineAllowableValues;
    public BlockingQueue<ScriptEngine> engineQ = null;

    public String getScriptEngineName() {
        return this.scriptEngineName;
    }

    public void setScriptEngineName(String scriptEngineName) {
        this.scriptEngineName = scriptEngineName;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getScriptBody() {
        return this.scriptBody;
    }

    public void setScriptBody(String scriptBody) {
        this.scriptBody = scriptBody;
    }

    public String[] getModules() {
        return this.modules;
    }

    public void setModules(String[] modules) {
        this.modules = modules;
    }

    public List<PropertyDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public List<AllowableValue> getScriptEngineAllowableValues() {
        return this.engineAllowableValues;
    }

    public void setDescriptors(List<PropertyDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        Map propertyMap = validationContext.getProperties();
        if (StringUtils.isEmpty((String)((String)propertyMap.get(ScriptingComponentUtils.SCRIPT_FILE))) == StringUtils.isEmpty((String)((String)propertyMap.get(ScriptingComponentUtils.SCRIPT_BODY)))) {
            results.add(new ValidationResult.Builder().subject("Script Body or Script File").valid(false).explanation("exactly one of Script File or Script Body must be set").build());
        }
        return results;
    }

    public void createResources() {
        this.descriptors = new ArrayList<PropertyDescriptor>();
        System.setProperty("org.jruby.embed.localvariable.behavior", "persistent");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> scriptEngineFactories = scriptEngineManager.getEngineFactories();
        if (scriptEngineFactories != null) {
            this.scriptEngineFactoryMap = new HashMap<String, ScriptEngineFactory>(scriptEngineFactories.size());
            LinkedList<AllowableValue> engineList = new LinkedList<AllowableValue>();
            for (ScriptEngineFactory factory : scriptEngineFactories) {
                engineList.add(new AllowableValue(factory.getLanguageName()));
                this.scriptEngineFactoryMap.put(factory.getLanguageName(), factory);
            }
            Collections.sort(engineList, (o1, o2) -> {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getValue().compareTo(o2.getValue());
            });
            this.engineAllowableValues = engineList;
            AllowableValue[] engines = engineList.toArray(new AllowableValue[engineList.size()]);
            this.SCRIPT_ENGINE = new PropertyDescriptor.Builder().name("Script Engine").required(true).description("The engine to execute scripts").allowableValues(engines).defaultValue(engines[0].getValue()).required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
            this.descriptors.add(this.SCRIPT_ENGINE);
        }
        this.descriptors.add(ScriptingComponentUtils.SCRIPT_FILE);
        this.descriptors.add(ScriptingComponentUtils.SCRIPT_BODY);
        this.descriptors.add(ScriptingComponentUtils.MODULES);
        this.isInitialized.set(true);
    }

    public static boolean isFile(String path) {
        return path != null && Files.isRegularFile(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public void setup(int numberOfScriptEngines, ComponentLog log) {
        if (this.scriptEngineConfiguratorMap.isEmpty()) {
            ServiceLoader<ScriptEngineConfigurator> configuratorServiceLoader = ServiceLoader.load(ScriptEngineConfigurator.class);
            for (ScriptEngineConfigurator configurator : configuratorServiceLoader) {
                this.scriptEngineConfiguratorMap.put(configurator.getScriptEngineName().toLowerCase(), configurator);
            }
        }
        this.setupEngines(numberOfScriptEngines, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupEngines(int numberOfScriptEngines, ComponentLog log) {
        this.engineQ = new LinkedBlockingQueue<ScriptEngine>(numberOfScriptEngines);
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader scriptEngineModuleClassLoader;
            if (StringUtils.isBlank((String)this.scriptEngineName)) {
                throw new IllegalArgumentException("The script engine name cannot be null");
            }
            ScriptEngineConfigurator configurator = this.scriptEngineConfiguratorMap.get(this.scriptEngineName.toLowerCase());
            URL[] additionalClasspathURLs = null;
            if (configurator != null) {
                additionalClasspathURLs = configurator.getModuleURLsForClasspath(this.modules, log);
            } else if (this.modules != null) {
                LinkedList<URL> urls = new LinkedList<URL>();
                for (String modulePathString : this.modules) {
                    try {
                        urls.add(new File(modulePathString).toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        log.error("{} is not a valid file, ignoring", new Object[]{modulePathString}, (Throwable)mue);
                    }
                }
                additionalClasspathURLs = urls.toArray(new URL[urls.size()]);
            }
            ClassLoader classLoader = scriptEngineModuleClassLoader = additionalClasspathURLs != null ? new URLClassLoader(additionalClasspathURLs, originalContextClassLoader) : originalContextClassLoader;
            if (scriptEngineModuleClassLoader != null) {
                Thread.currentThread().setContextClassLoader(scriptEngineModuleClassLoader);
            }
            for (int i = 0; i < numberOfScriptEngines; ++i) {
                ScriptEngine scriptEngine = this.createScriptEngine();
                try {
                    if (configurator != null) {
                        configurator.init(scriptEngine, this.modules);
                    }
                    if (this.engineQ.offer(scriptEngine)) continue;
                    log.error("Error adding script engine {}", new Object[]{scriptEngine.getFactory().getEngineName()});
                    continue;
                }
                catch (ScriptException se) {
                    log.error("Error initializing script engine configurator {}", new Object[]{this.scriptEngineName});
                    if (!log.isDebugEnabled()) continue;
                    log.error("Error initializing script engine configurator", (Throwable)se);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    public void setupVariables(PropertyContext context) {
        this.scriptEngineName = context.getProperty(this.SCRIPT_ENGINE).getValue();
        this.scriptPath = context.getProperty(ScriptingComponentUtils.SCRIPT_FILE).evaluateAttributeExpressions().getValue();
        this.scriptBody = context.getProperty(ScriptingComponentUtils.SCRIPT_BODY).getValue();
        String modulePath = context.getProperty(ScriptingComponentUtils.MODULES).evaluateAttributeExpressions().getValue();
        this.modules = !StringUtils.isEmpty((String)modulePath) ? modulePath.split(",") : new String[0];
    }

    protected ScriptEngine createScriptEngine() {
        ScriptEngineFactory factory = this.scriptEngineFactoryMap.get(this.scriptEngineName);
        if (factory == null) {
            return null;
        }
        return factory.getScriptEngine();
    }

    public void stop() {
        if (this.engineQ != null) {
            this.engineQ.clear();
        }
    }
}

